/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport;

import com.cashctrl.bookingimport.CLI;
import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.Journal;
import com.cashctrl.bookingimport.Organization;
import com.cashctrl.bookingimport.parser.BookingParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class BookingImport {
    private static final CLI cli = new CLI();
    private static final Error error = Error.getInstance();
    private static Organization organization;

    public static void main(String[] args) {
        if (!cli.parseArguments(args)) {
            return;
        }
        if (cli.wannaSeeHelp()) {
            cli.printHelp();
            return;
        }
        if (!cli.validateArguments()) {
            return;
        }
        error.setMode(Error.Mode.Full);
        error.setLanguage(Error.Language.English);
        System.out.println("------------ Start import ------------");
        for (String file : cli.get("file").split(" ")) {
            try {
                String org = cli.get("org");
                FileInputStream fileStream = new FileInputStream(file);
                InputStreamReader stream = new InputStreamReader((InputStream)fileStream, StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(stream, fileStream.available());
                bufferedReader.mark(fileStream.available());
                if (BookingImport.importFromCSV(org, cli.get("key"), cli.get("invoiceField"), cli.get("customerField"), cli.get("revenue"), cli.get("expense"), cli.get("balance"), bufferedReader)) {
                    System.out.println("Successfully imported " + file + " into " + org);
                    continue;
                }
                System.out.println("Failed to import " + file + " into " + org);
            }
            catch (IOException ignored) {
                System.out.println("error: file not found : " + cli.get("file"));
                return;
            }
        }
        System.out.println(error.get());
        error.clear();
    }

    public static <T extends Closeable> boolean importFromCSV(String orgName, String key, String invoiceField, String customerField, String revenue, String expense, String balance, T input) {
        StringBuilder revenueId = new StringBuilder();
        StringBuilder expenseId = new StringBuilder();
        StringBuilder balanceId = new StringBuilder();
        Journal journal = new Journal();
        organization = new Organization(orgName, key);
        if (!BookingImport.getAccountIds(revenue, expense, balance, revenueId, expenseId, balanceId, journal.list(organization, "/api/v1/account/list.json"))) {
            return false;
        }
        BookingParser parser = BookingParser.evaluateParser(revenueId.toString(), expenseId.toString(), balanceId.toString(), input);
        if (parser == null) {
            error.appendLine(new Error.Message("Error: Not a valid Stripe, PayPal, SumUp or Payrexx csv.", "Fehler: Keine g\u00fcltige Stripe-, PayPal-, SumUp- oder Payrexx-csv-Datei."));
            return false;
        }
        parser.setMetadataFields(invoiceField, customerField);
        List<Entry> entries = parser.parse();
        if (entries == null || entries.size() == 0) {
            error.appendLine(new Error.Message("Error: No \"Paid\" payments found.", "Fehler: Keine bezahlten (Paid) Zahlungen gefunden."));
            return false;
        }
        entries.forEach(entry -> {
            if (!journal.createEntry((Entry)entry, organization)) {
                error.appendLine(new Error.Message("Error: Failed to create " + entry + " inside " + organization.getUrl() + ".", "Fehler: Das erstellen von " + entry + " in " + organization.getUrl() + " ist fehlgeschlagen."));
            }
        });
        parser.close();
        return true;
    }

    private static boolean getAccountIds(String revenue, String expense, String balance, StringBuilder revenueId, StringBuilder expenseId, StringBuilder balanceId, JsonArray accounts) {
        if (accounts == null) {
            error.appendLine(new Error.Message("Error: Failed to get accounts from organization " + organization.getUrl() + ".", "Fehler: Konten von der Organisation " + organization.getUrl() + " k\u00f6nnen nicht abgerufen werden."));
            return false;
        }
        for (int idx = 0; idx < accounts.size(); ++idx) {
            JsonObject account = accounts.get(idx).getAsJsonObject();
            if (!Journal.has(account, "number")) continue;
            String number = account.get("number").getAsString();
            if (number.equals(revenue)) {
                revenueId.append(account.get("id").getAsInt());
            }
            if (number.equals(expense)) {
                expenseId.append(account.get("id").getAsInt());
            }
            if (number.equals(balance)) {
                balanceId.append(account.get("id").getAsInt());
            }
            if (revenueId.isEmpty() || expenseId.isEmpty() || balanceId.isEmpty()) continue;
            return true;
        }
        if (revenueId.isEmpty()) {
            error.appendLine(new Error.Message("Error: Could not find " + revenue + " revenue account.", "Fehler: Konnte das Ertragskonto " + revenue + " nicht finden."));
        }
        if (expenseId.isEmpty()) {
            error.appendLine(new Error.Message("Error: Could not find " + expense + " expense account.", "Fehler: Konnte das Aufwandskonto " + expense + " nicht finden."));
        }
        if (balanceId.isEmpty()) {
            error.appendLine(new Error.Message("Error: Could not find " + balance + " balance account.", "Fehler: Konnte das Bilanzkonto " + balance + " nicht finden."));
        }
        return false;
    }
}

