/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.parser;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.parser.PayPalParser;
import com.cashctrl.bookingimport.parser.PayRexxParser;
import com.cashctrl.bookingimport.parser.StripeParser;
import com.cashctrl.bookingimport.parser.SumUpParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public abstract class BookingParser {
    protected static final CSVFormat defaultFormat = CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase();
    protected static final Error error = Error.getInstance();
    protected final String revenueId;
    protected final String expenseId;
    protected final String balanceId;
    protected final Closeable input;
    protected final List<String> header = new ArrayList<String>();
    protected final CSVParser csvParser;
    private final List<List<String>> columns;
    protected List<String> METADATA_COLUMN_INVOICE = List.of("");
    protected List<String> METADATA_COLUMN_CUSTOMER = List.of("");

    protected <T extends Closeable> BookingParser(CSVParser csvParser, List<List<String>> columns, T input, String revenueId, String expenseId, String balanceId) {
        this.csvParser = csvParser;
        this.columns = columns;
        this.input = input;
        this.revenueId = revenueId;
        this.expenseId = expenseId;
        this.balanceId = balanceId;
        this.header.addAll(csvParser.getHeaderNames());
    }

    public abstract List<Entry> parse();

    public static <T extends Closeable> BookingParser evaluateParser(String revenueId, String expenseId, String balanceId, T input) {
        CSVParser csv = BookingParser.getParser(input, defaultFormat);
        if (csv == null) {
            return null;
        }
        StripeParser stripeParser = new StripeParser(csv, input, revenueId, expenseId, balanceId);
        if (stripeParser.isValid()) {
            return stripeParser;
        }
        PayPalParser paypalParser = new PayPalParser(csv, input, revenueId, expenseId, balanceId);
        if (paypalParser.isValid()) {
            return paypalParser;
        }
        SumUpParser sumupParser = new SumUpParser(csv, input, revenueId, expenseId, balanceId);
        if (sumupParser.isValid()) {
            return sumupParser;
        }
        BookingParser.reset(input);
        csv = BookingParser.getParser(input, defaultFormat.withDelimiter(';'));
        PayRexxParser payrexxParser = new PayRexxParser(csv, input, revenueId, expenseId, balanceId);
        if (payrexxParser.isValid()) {
            return payrexxParser;
        }
        error.appendLine(new Error.Message("Error: The stream layout could not be determined.", "Fehler: Das Stream-Layout konnte nicht ermittelt werden."));
        return null;
    }

    private static <T extends Closeable> CSVParser getParser(T input, CSVFormat format) {
        CSVParser csv;
        block4: {
            csv = null;
            try {
                if (input instanceof BufferedReader) {
                    csv = format.parse((BufferedReader)input);
                    break block4;
                }
                if (input instanceof InputStream) {
                    csv = format.parse(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
                    break block4;
                }
                throw new IllegalArgumentException("Input must be of type import java.io.BufferedReader; or import java.io.InputStream;");
            }
            catch (IOException | IllegalArgumentException e) {
                error.appendLine(new Error.Message("Error: Could not read stream" + (String)(error.getMode().equals((Object)Error.Mode.Full) ? ", message:" + e : "."), "Fehler: Konnte die Datei nicht lesen" + (String)(error.getMode().equals((Object)Error.Mode.Full) ? ", Nachricht: " + e : ".")));
            }
        }
        return csv;
    }

    private static <T extends Closeable> void reset(T input) {
        try {
            BufferedReader reader;
            InputStream stream;
            if (input instanceof InputStream && (stream = (InputStream)input).markSupported()) {
                stream.reset();
            } else if (input instanceof BufferedReader && (reader = (BufferedReader)input).markSupported()) {
                reader.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        block4: {
            try {
                if (this.csvParser != null && !this.csvParser.isClosed()) {
                    this.csvParser.close();
                }
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException e) {
                if (!error.getMode().equals((Object)Error.Mode.Full)) break block4;
                error.appendLine(new Error.Message("Error: Failed to close file handle.", "Fehler: Beim schliessen der Datei ist ein fehler aufgetreten."));
            }
        }
    }

    protected String getValue(CSVRecord record, List<String> keys) {
        for (String key : keys) {
            if (!record.isMapped(key)) continue;
            return record.get(key);
        }
        return null;
    }

    public void setMetadataFields(String invoiceField, String customerField) {
        if (invoiceField != null && !invoiceField.isEmpty()) {
            this.METADATA_COLUMN_INVOICE = List.of(invoiceField + " (metadata)", invoiceField);
        }
        if (customerField != null && !customerField.isEmpty()) {
            this.METADATA_COLUMN_CUSTOMER = List.of(customerField + " (metadata)", customerField);
        }
    }

    protected boolean isValid() {
        return this.csvParser != null && this.columns != null && this.validate();
    }

    protected boolean validate() {
        if (this.header.size() < this.columns.size()) {
            return false;
        }
        for (List<String> column : this.columns) {
            boolean has = false;
            for (String col : column) {
                if (!this.header.contains(col)) continue;
                has = true;
                break;
            }
            if (has) continue;
            return false;
        }
        return true;
    }
}

