/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.HttpMethods;
import com.cashctrl.bookingimport.Organization;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class Journal {
    private static final HttpMethods http = HttpMethods.getInstance();
    private static final Error error = Error.getInstance();
    private static final Gson gson = new Gson();
    private static final List<String> supportedCurrencies = new ArrayList<String>(Arrays.asList("aud", "btc", "cad", "chf", "cny", "dkk", "eur", "gbp", "inr", "jpy", "rub", "sek", "thb", "usd"));
    private static final int limit = 99999;
    private JsonArray people = null;
    private JsonArray currencies = null;

    public boolean createEntry(Entry entry, Organization organization) {
        HttpResponse<String> response;
        String[] dateSplit;
        HashMap<String, String> data = new HashMap<String, String>();
        boolean refund = false;
        float amount = Float.parseFloat(entry.amount());
        if (amount < 0.0f) {
            refund = true;
            data.put("creditId", entry.balanceId());
            data.put("debitId", entry.revenueId());
        } else {
            data.put("creditId", entry.revenueId());
            data.put("debitId", entry.balanceId());
        }
        data.put("amount", Float.toString(Math.abs(amount)));
        String date = entry.date();
        if (date != null && !date.isEmpty() && (dateSplit = date.split(" ")).length > 0) {
            data.put("dateAdded", dateSplit[0]);
        }
        if (entry.description() != null && !entry.description().isEmpty()) {
            data.put("title", entry.description());
        }
        if (entry.referenceNr() != null && !entry.referenceNr().isEmpty()) {
            data.put("reference", entry.referenceNr());
        }
        if (entry.customerNr() != null && !entry.customerNr().isEmpty()) {
            if (this.people == null) {
                this.people = this.list(organization, "/api/v1/person/list.json");
            }
            if (this.people != null && this.people.size() > 0) {
                for (int idx = 0; idx < this.people.size(); ++idx) {
                    JsonObject person = this.people.get(idx).getAsJsonObject();
                    if (!Journal.has(person, "nr") || !Journal.has(person, "id") || !person.get("nr").getAsString().equals(entry.customerNr())) continue;
                    data.put("associateId", Integer.toString(person.get("id").getAsInt()));
                }
            }
        }
        if (entry.currency() != null && !entry.currency().isEmpty()) {
            if (this.currencies == null) {
                this.currencies = this.list(organization, "/api/v1/currency/list.json");
            }
            if (this.currencies != null && this.currencies.size() > 0) {
                boolean exists = false;
                for (int idx = 0; idx < this.currencies.size(); ++idx) {
                    JsonObject currency = this.currencies.get(idx).getAsJsonObject();
                    if (!Journal.has(currency, "code") || !Journal.has(currency, "id") || !Journal.has(currency, "rate") || !currency.get("code").getAsString().equalsIgnoreCase(entry.currency())) continue;
                    data.put("currencyId", Integer.toString(currency.get("id").getAsInt()));
                    if (!supportedCurrencies.contains(currency.get("code").getAsString().toLowerCase())) {
                        data.put("currencyRate", Float.toString(currency.get("rate").getAsFloat()));
                    }
                    exists = true;
                    break;
                }
                if (!exists) {
                    HttpResponse<String> response2 = this.createCurrency(entry.currency(), organization);
                    if (this.checkResponse(response2)) {
                        this.currencies = null;
                        int currencyId = this.insertId(response2);
                        if (currencyId != -1) {
                            data.put("currencyId", Integer.toString(currencyId));
                            if (!supportedCurrencies.contains(entry.currency().toLowerCase())) {
                                data.put("currencyRate", "1");
                            }
                        } else {
                            error.appendLine(new Error.Message("Error: Failed to get the insert id of the created currency", "Fehler: Konnte die Einf\u00fcge-ID der erstellten W\u00e4hrung nicht abrufen"));
                        }
                    } else {
                        error.appendLine(new Error.Message("Error: Failed to create the currency", "Fehler: Fehler beim erstellen der W\u00e4hrung"));
                    }
                }
            }
        }
        if (!this.checkResponse(response = http.post(organization, "/api/v1/journal/create.json", data))) {
            return false;
        }
        Float fee = Float.valueOf(Float.parseFloat(entry.fee()));
        if (fee.equals(Float.valueOf(0.0f))) {
            return true;
        }
        data.put("creditId", refund ? entry.expenseId() : entry.balanceId());
        data.put("debitId", refund ? entry.balanceId() : entry.expenseId());
        data.put("amount", Float.toString(Math.abs(fee.floatValue())));
        response = http.post(organization, "/api/v1/journal/create.json", data);
        return this.checkResponse(response);
    }

    private HttpResponse<String> createCurrency(String code, Organization organization) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("code", code);
        if (!supportedCurrencies.contains(code.toLowerCase())) {
            data.put("rate", "1");
        }
        return http.post(organization, "/api/v1/currency/create.json", data);
    }

    public JsonArray list(Organization organization, String endpoint) {
        JsonObject body;
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("limit", Integer.toString(99999));
        HttpResponse<String> response = http.get(organization, endpoint, filter);
        if (response != null && response.statusCode() == 200 && Journal.has(body = gson.fromJson(response.body(), JsonObject.class), "data")) {
            return body.get("data").getAsJsonArray();
        }
        return null;
    }

    protected boolean checkResponse(HttpResponse<String> response) {
        if (response == null || response.statusCode() != 200) {
            return false;
        }
        JsonObject jsonResponse = gson.fromJson(response.body(), JsonObject.class);
        if (Journal.has(jsonResponse, "success")) {
            if (jsonResponse.get("success").getAsBoolean()) {
                return true;
            }
            if (Journal.has(jsonResponse, "errors")) {
                JsonArray errors = jsonResponse.get("errors").getAsJsonArray();
                for (int idx = 0; idx < errors.size(); ++idx) {
                    JsonObject errorObj = errors.get(idx).getAsJsonObject();
                    if (error.getMode().equals((Object)Error.Mode.Full)) {
                        String field = Journal.has(errorObj, "field") ? errorObj.get("field").getAsString() : "null";
                        error.appendLine(new Error.Message("Field: " + field, "Feld: " + field));
                    }
                    String message = Journal.has(errorObj, "message") ? errorObj.get("message").getAsString() : "null";
                    error.appendLine(new Error.Message("Message: " + message, "Nachricht: " + message));
                }
            }
            if (Journal.has(jsonResponse, "message")) {
                String message = jsonResponse.get("message").getAsString();
                error.appendLine(new Error.Message("Message: " + message, "Nachricht: " + message));
            }
        }
        return false;
    }

    public static boolean has(JsonObject object, String property) {
        return object != null && object.has(property) && !object.get(property).isJsonNull();
    }

    protected int insertId(HttpResponse<String> response) {
        if (response == null || response.statusCode() != 200) {
            return -1;
        }
        JsonObject jsonResponse = gson.fromJson(response.body(), JsonObject.class);
        return Journal.has(jsonResponse, "insertId") ? jsonResponse.get("insertId").getAsInt() : -1;
    }
}

