/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport;

import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.Organization;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;

public final class HttpMethods {
    public static final int BURST_FIRE = 100;
    public static final int THROTTLE = 10;
    public static final int WAIT = 1000;
    private static final Error error = Error.getInstance();
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).proxy(ProxySelector.getDefault()).build();
    private static HttpMethods instance;
    private int requestCounter = 0;

    private HttpMethods() {
    }

    public static HttpMethods getInstance() {
        if (instance == null) {
            instance = new HttpMethods();
        }
        return instance;
    }

    public HttpResponse<String> get(Organization org, String uri, HashMap<String, String> params) {
        StringBuilder parameter = new StringBuilder();
        if (params == null) {
            return null;
        }
        params.put("lang", HttpMethods.error.getLanguage().abbreviation);
        parameter.append("?");
        params.forEach((key, value) -> {
            parameter.append(URLEncoder.encode(key, StandardCharsets.UTF_8));
            parameter.append("=");
            parameter.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
            if (params.size() > 1) {
                parameter.append("&");
            }
        });
        return this.get(org, uri + parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse<String> get(Organization org, String uri) {
        HttpResponse<String> response;
        block11: {
            response = null;
            this.maybeDelayRequest();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(org.getUrl() + uri)).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json").header("Authorization", org.getAuthorization()).GET().build();
                ++this.requestCounter;
                response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | IllegalStateException | InterruptedException exception) {
                String e = error.getMode().equals((Object)Error.Mode.Full) ? exception.toString() : "";
                error.appendLine(new Error.Message("Error: Organisation not found. " + e, "Fehler: Organisation nicht gefunden. " + e));
                break block11;
            }
            finally {
                if (response == null || response.statusCode() != 200) {
                    if (error.getMode().equals((Object)Error.Mode.Full)) {
                        error.appendLine(new Error.Message("GET request failed!", "GET Anfrage fehlgeschlagen!"));
                    }
                    if (response != null) {
                        this.printResponse(response);
                    }
                }
            }
            if (response == null || response.statusCode() != 200) {
                if (error.getMode().equals((Object)Error.Mode.Full)) {
                    error.appendLine(new Error.Message("GET request failed!", "GET Anfrage fehlgeschlagen!"));
                }
                if (response != null) {
                    this.printResponse(response);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse<String> post(Organization org, String uri, HashMap<String, String> data) {
        HttpResponse<String> response;
        block11: {
            data.put("lang", HttpMethods.error.getLanguage().abbreviation);
            response = null;
            this.maybeDelayRequest();
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(org.getUrl() + uri)).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", org.getAuthorization()).POST(this.ofData(data)).build();
                ++this.requestCounter;
                response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | IllegalStateException | InterruptedException exception) {
                String e = error.getMode().equals((Object)Error.Mode.Full) ? exception.toString() : "";
                error.appendLine(new Error.Message("Error: Organisation not found. " + e, "Fehler: Organisation nicht gefunden. " + e));
                break block11;
            }
            finally {
                if (response == null || response.statusCode() != 200) {
                    if (error.getMode().equals((Object)Error.Mode.Full)) {
                        error.appendLine(new Error.Message("POST request failed!", "POST Anfrage fehlgeschlagen!"));
                    }
                    if (response != null) {
                        this.printResponse(response);
                    }
                }
            }
            if (response == null || response.statusCode() != 200) {
                if (error.getMode().equals((Object)Error.Mode.Full)) {
                    error.appendLine(new Error.Message("POST request failed!", "POST Anfrage fehlgeschlagen!"));
                }
                if (response != null) {
                    this.printResponse(response);
                }
            }
        }
        return response;
    }

    public HttpRequest.BodyPublisher ofData(HashMap<String, String> data) {
        StringBuilder dataStr = new StringBuilder();
        data.forEach((key, value) -> {
            if (dataStr.length() > 0) {
                dataStr.append("&");
            }
            dataStr.append(URLEncoder.encode(key, StandardCharsets.UTF_8));
            dataStr.append("=");
            dataStr.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        });
        return HttpRequest.BodyPublishers.ofString(dataStr.toString());
    }

    private void printResponse(HttpResponse<String> response) {
        error.appendLine(new Error.Message("Status: " + response.statusCode(), "Status: " + response.statusCode()));
        error.appendLine(new Error.Message("Message: " + response.body(), "Nachricht: " + response.body()));
    }

    private void maybeDelayRequest() {
        if (this.requestCounter >= 100) {
            try {
                Thread.sleep(1000L);
                this.requestCounter -= 10;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }
}

