/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.parser;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.parser.BookingParser;
import java.io.Closeable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class StripeParser
extends BookingParser {
    private static final List<String> COLUMN_AMOUNT = List.of("Converted Amount");
    private static final List<String> COLUMN_DESCRIPTION = List.of("Description");
    private static final List<String> COLUMN_FEE = List.of("Fee");
    private static final List<String> COLUMN_CREATED = List.of("Created (UTC)");
    private static final List<String> COLUMN_STATUS = List.of("Status");
    private static final List<String> COLUMN_CURRENCY = List.of("Converted Currency");
    private static final List<String> COLUMN_REFUNDED_AMOUNT = List.of("Converted Amount Refunded");

    protected <T extends Closeable> StripeParser(CSVParser csvParser, T input, String revenueId, String expenseId, String balanceId) {
        super(csvParser, List.of(COLUMN_AMOUNT, COLUMN_DESCRIPTION, COLUMN_FEE, COLUMN_CREATED, COLUMN_STATUS, COLUMN_CURRENCY, COLUMN_REFUNDED_AMOUNT), input, expenseId, revenueId, balanceId);
    }

    @Override
    public List<Entry> parse() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (CSVRecord record : this.csvParser) {
            String status = this.getValue(record, COLUMN_STATUS);
            if (status == null || !status.equalsIgnoreCase("Paid")) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String created = this.getValue(record, COLUMN_CREATED);
            try {
                Date date = dateFormat.parse(created);
                dateFormat.setTimeZone(TimeZone.getTimeZone("Europe/Zurich"));
                created = dateFormat.format(date);
            }
            catch (ParseException e) {
                error.appendLine(new Error.Message("Error: Failed to parse time: " + this.getValue(record, COLUMN_DESCRIPTION), "Fehler: Beim parsen der Zeit: " + this.getValue(record, COLUMN_DESCRIPTION)));
                continue;
            }
            entries.add(new Entry(this.revenueId, this.expenseId, this.balanceId, created, this.getValue(record, COLUMN_DESCRIPTION), this.getValue(record, COLUMN_AMOUNT), this.getValue(record, COLUMN_FEE), this.getValue(record, COLUMN_CURRENCY), this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE)));
            String refunded = this.getValue(record, COLUMN_REFUNDED_AMOUNT);
            if (refunded.equals("0.00")) continue;
            float refundedAmount = Float.parseFloat(refunded) * -1.0f;
            entries.add(new Entry(this.revenueId, this.expenseId, this.balanceId, created, this.getValue(record, COLUMN_DESCRIPTION), Float.toString(refundedAmount), "0.0", this.getValue(record, COLUMN_CURRENCY), this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE)));
        }
        return entries;
    }
}

