/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLI {
    private CommandLine cmd;

    public boolean parseArguments(String[] args) {
        if (args == null || args.length <= 0) {
            this.printHelp();
            return false;
        }
        try {
            DefaultParser parser = new DefaultParser();
            this.cmd = parser.parse(this.getOptions(), args);
            if (this.cmd != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            System.out.print("Failed to parse the arguments! " + parseException);
        }
        return false;
    }

    public boolean wannaSeeHelp() {
        return this.cmd.hasOption("h") || this.cmd.hasOption("help");
    }

    public void printHelp() {
        new HelpFormatter().printHelp("CashCtrl - booking-import", this.getOptions());
    }

    public boolean validateArguments() {
        return this.isArgumentValid("org") && this.isArgumentValid("key") && this.isArgumentValid("file") && this.isArgumentValid("revenue") && this.isArgumentValid("expense") && this.isArgumentValid("balance");
    }

    public String get(String option) {
        return this.cmd.getOptionValue(option);
    }

    private boolean isArgumentValid(String arg) {
        if (!this.cmd.hasOption(arg)) {
            System.out.print("Missing argument ");
            this.printArgInfo(arg);
            return false;
        }
        String value = this.cmd.getOptionValue(arg);
        if (value == null || value.isEmpty()) {
            System.out.print("Has no subsequent value ");
            this.printArgInfo(arg);
            return false;
        }
        return true;
    }

    private void printArgInfo(String arg) {
        Option option = this.getOptions().getOption(arg);
        if (option != null) {
            System.out.println("-" + option.getOpt() + " <arg> " + option.getDescription());
        }
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Display help.");
        options.addOption("org", true, "Organisation name or URL.");
        options.addOption("key", true, "Organisation key.");
        options.addOption("file", true, "Stripe, PayPal, SumUp or Payrexx CSV file.");
        options.addOption("revenue", true, "Revenue account in CashCtrl.");
        options.addOption("expense", true, "Expense account in CashCtrl.");
        options.addOption("balance", true, "Balance account (Stripe, PayPal, SumUp or Payrexx) in CashCtrl.");
        options.addOption("invoiceField", true, "Invoice number referencing the transaction.");
        options.addOption("customerField", true, "Customer number referencing a person inside CashCtrl.");
        return options;
    }
}

