/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.web;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.Locale;

public class WebUtils {
    private static final double MAX_ACCOUNT = Double.MAX_VALUE;
    private static final double MIN_ACCOUNT = 0.0;
    private static final int COOKIE_MAX_AGE = 315360000;

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        if (request != null && request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return new Cookie(name, "");
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        return WebUtils.getCookieByName(request, name).getValue();
    }

    public static void setCookie(HttpServletResponse response, String name, String value) {
        WebUtils.setCookies(response, new Cookie[]{new Cookie(name, value)});
    }

    public static void setCookies(HttpServletResponse response, Cookie[] cookies) {
        for (Cookie cookie : cookies) {
            cookie.setMaxAge(315360000);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    public static boolean isAccountValid(double account) {
        return account < Double.MAX_VALUE && account >= 0.0;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getSupportedPreferredLanguage(HttpServletRequest request) {
        Enumeration locales = request.getLocales();
        String language = "en";
        if (locales != null) {
            while (locales.hasMoreElements()) {
                Locale locale = (Locale)locales.nextElement();
                String lang = locale.getLanguage();
                if (lang.equalsIgnoreCase("en")) {
                    language = lang;
                    break;
                }
                if (!lang.equalsIgnoreCase("de")) continue;
                language = lang;
                break;
            }
        }
        return language;
    }
}

