/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport;

public final class Error {
    private final StringBuilder error = new StringBuilder();
    private static Error instance = null;
    private Language language = Language.English;
    private Mode mode = Mode.Full;

    private Error() {
    }

    public static Error getInstance() {
        if (instance == null) {
            instance = new Error();
        }
        return instance;
    }

    public void appendLine(Message error) {
        this.append(this.switchLanguage(error) + "\n");
    }

    private void append(String error) {
        this.error.append(error);
    }

    public String get() {
        return this.error.toString();
    }

    public void clear() {
        this.error.setLength(0);
    }

    private String switchLanguage(Message msg) {
        switch (this.language) {
            case English: {
                return msg.english();
            }
            case German: {
                return msg.german();
            }
        }
        throw new IllegalArgumentException();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Language {
        English(1, "en"),
        German(2, "de");

        final int id;
        final String abbreviation;

        private Language(int id, String abbreviation) {
            this.id = id;
            this.abbreviation = abbreviation;
        }

        public int id() {
            return this.id;
        }

        public String abbreviation() {
            return this.abbreviation;
        }
    }

    public static enum Mode {
        Brief,
        Full;

    }

    public record Message(String english, String german) {
    }
}

