/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.web;

import com.cashctrl.bookingimport.BookingImport;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.web.WebUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;

@WebServlet(name="ImportServlet", urlPatterns={"/en/import", "/de/import"})
@MultipartConfig(maxFileSize=0x1900000L, maxRequestSize=0x2800000L, fileSizeThreshold=0x100000)
public class ImportServlet
extends HttpServlet {
    private static final Error error = Error.getInstance();
    private static final String direct = "bookingimport.jsp";
    private String revenue;
    private String expense;
    private String balance;
    private String organisationName;
    private String organisationKey;
    private String invoiceField;
    private String customerField;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        if (session == null) {
            response.sendRedirect(direct);
            return;
        }
        this.revenue = request.getParameter("revenue");
        this.expense = request.getParameter("expense");
        this.balance = request.getParameter("balance");
        this.organisationName = request.getParameter("organisationName");
        this.organisationKey = request.getParameter("organisationKey");
        this.invoiceField = request.getParameter("invoiceField");
        this.customerField = request.getParameter("customerField");
        if (this.validate(session)) {
            response.sendRedirect(direct);
            return;
        }
        this.setCookies(response);
        Collection<Part> parts = this.getMultipart(request, session);
        if (parts == null) {
            response.sendRedirect(direct);
            return;
        }
        this.setLanguage(request);
        parts.forEach(part -> this.importCSV(session, (Part)part));
        response.sendRedirect(direct);
    }

    private void importCSV(HttpSession session, Part part) {
        if (part.getName().equals("csvFile")) {
            try {
                if (BookingImport.importFromCSV(this.organisationName, this.organisationKey, this.invoiceField, this.customerField, this.revenue, this.expense, this.balance, part.getInputStream())) {
                    if (error.get().length() > 0) {
                        session.setAttribute("alert-type", (Object)"warning");
                        session.setAttribute("alert-head", (Object)ImportServlet.getHead(State.WARNING));
                        session.setAttribute("alert-message", (Object)ImportServlet.prepareMessage(error.get()));
                    } else {
                        session.setAttribute("alert-type", (Object)"success");
                        session.setAttribute("alert-head", (Object)ImportServlet.getHead(State.SUCCESS));
                        session.setAttribute("alert-message", (Object)"");
                    }
                } else {
                    session.setAttribute("alert-type", (Object)"danger");
                    session.setAttribute("alert-head", (Object)ImportServlet.getHead(State.ERROR));
                    session.setAttribute("alert-message", (Object)ImportServlet.prepareMessage(error.get()));
                }
                error.clear();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setLanguage(HttpServletRequest request) {
        String lang = WebUtils.getCookieValue(request, "lang");
        AtomicReference<Error.Language> errorLanguage = new AtomicReference<Error.Language>(Error.Language.English);
        EnumSet.allOf(Error.Language.class).forEach(l -> {
            if (l.abbreviation().equalsIgnoreCase(lang)) {
                errorLanguage.set((Error.Language)((Object)l));
            }
        });
        error.setLanguage(errorLanguage.get());
        error.setMode(Error.Mode.Brief);
    }

    private Collection<Part> getMultipart(HttpServletRequest request, HttpSession session) throws ServletException {
        Collection parts;
        try {
            parts = request.getParts();
            if (parts == null || parts.size() < 1) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            session.setAttribute("alert-type", (Object)"danger");
            session.setAttribute("alert-head", (Object)ImportServlet.getHead(State.ERROR));
            session.setAttribute("alert-message", (Object)"Failed to get csv file from request, please try again!");
            return null;
        }
        return parts;
    }

    private void setCookies(HttpServletResponse response) {
        Cookie[] cookies = new Cookie[]{new Cookie("revenue", this.revenue), new Cookie("expense", this.expense), new Cookie("balance", this.balance), new Cookie("organisationName", this.organisationName), new Cookie("invoiceField", this.invoiceField), new Cookie("customerField", this.customerField)};
        WebUtils.setCookies(response, cookies);
    }

    private boolean validate(HttpSession session) {
        try {
            if (!WebUtils.isAccountValid(Double.parseDouble(this.revenue)) || !WebUtils.isAccountValid(Double.parseDouble(this.expense)) || !WebUtils.isAccountValid(Double.parseDouble(this.balance)) || WebUtils.isNullOrEmpty(this.organisationName) || WebUtils.isNullOrEmpty(this.organisationKey)) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            session.setAttribute("alert-type", (Object)"danger");
            session.setAttribute("alert-head", (Object)ImportServlet.getHead(State.ERROR));
            session.setAttribute("alert-message", (Object)"Failed to validate input parameter, please try again!");
            return true;
        }
        return false;
    }

    private static String prepareMessage(String msg) {
        Error.Language language = error.getLanguage();
        if (language.equals((Object)Error.Language.German)) {
            msg = msg.replace("\n", "<br>").replace("Fehler:", "<strong>Fehler: </strong>").replace("Feld:", "<strong>Feld: </strong>").replace("Nachricht:", "<strong>Nachricht: </strong>").replace("Status:", "<strong>Status: </strong>");
        } else if (language.equals((Object)Error.Language.English)) {
            msg = msg.replace("\n", "<br>").replace("Error:", "<strong>Error: </strong>").replace("Field:", "<strong>Field. </strong>").replace("Message:", "<strong>Message: </strong>").replace("Status:", "<strong>Status: </strong>");
        }
        return msg;
    }

    private static String getHead(State state) {
        Error.Language language = error.getLanguage();
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case State.SUCCESS -> {
                if (language.equals((Object)Error.Language.English)) {
                    yield "Successfully imported into CashCtrl!";
                }
                yield "Erfolgreich in CashCtrl importiert!";
            }
            case State.WARNING -> {
                if (language.equals((Object)Error.Language.English)) {
                    yield "Warnings occurred during import!";
                }
                yield "Beim importieren sind Warnungen aufgetreten!";
            }
            case State.ERROR -> language.equals((Object)Error.Language.English) ? "An error occurred during import!" : "Beim Importieren ist ein Fehler aufgetreten!";
        };
    }

    private static enum State {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

