/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.parser;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.parser.BookingParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class PayRexxParser
extends BookingParser {
    private static final List<String> COLUMN_AMOUNT = List.of("Gross", "Brutto");
    private static final List<String> COLUMN_EMAIL = List.of("Email address", "E-Mail-Adresse");
    private static final List<String> COLUMN_FEE = List.of("Transaction fee", "Transaktionsgeb\u00fchr");
    private static final List<String> COLUMN_CREATED = List.of("Date and time", "Datum und Zeit");
    private static final List<String> COLUMN_STATUS = List.of("Status");
    private static final List<String> COLUMN_CURRENCY = List.of("Currency", "W\u00e4hrung");
    private static final List<String> COLUMN_REFUNDED_AMOUNT = List.of("Refund", "R\u00fcckerstattung");
    private static final List<String> ACCEPTABLE_STATUS = List.of("Confirmed", "Partially refunded", "Refunded", "Best\u00e4tigt", "Teilr\u00fcckerstattung", "R\u00fcckerstattet");

    protected <T extends Closeable> PayRexxParser(CSVParser csvParser, T input, String revenueId, String expenseId, String balanceId) {
        super(csvParser, List.of(COLUMN_AMOUNT, COLUMN_EMAIL, COLUMN_FEE, COLUMN_CREATED, COLUMN_STATUS, COLUMN_CURRENCY, COLUMN_REFUNDED_AMOUNT), input, revenueId, expenseId, balanceId);
    }

    @Override
    public List<Entry> parse() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (CSVRecord record : this.csvParser) {
            String status = this.getValue(record, COLUMN_STATUS);
            if (status == null || !this.isStatusValid(status)) continue;
            entries.add(new Entry(this.revenueId, this.expenseId, this.balanceId, this.getValue(record, COLUMN_CREATED), this.getValue(record, COLUMN_EMAIL), this.getValue(record, COLUMN_AMOUNT), this.getValue(record, COLUMN_FEE), this.getValue(record, COLUMN_CURRENCY), this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE)));
            String refunded = this.getValue(record, COLUMN_REFUNDED_AMOUNT);
            if (refunded.equals("0")) continue;
            float refundedAmount = Float.parseFloat(refunded) * -1.0f;
            entries.add(new Entry(this.revenueId, this.expenseId, this.balanceId, this.getValue(record, COLUMN_CREATED), this.getValue(record, COLUMN_EMAIL), Float.toString(refundedAmount), "0.0", this.getValue(record, COLUMN_CURRENCY), this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE)));
        }
        return entries;
    }

    protected boolean isStatusValid(String status) {
        for (String s : ACCEPTABLE_STATUS) {
            if (!s.equalsIgnoreCase(status)) continue;
            return true;
        }
        return false;
    }
}

