/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.parser;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.parser.BookingParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class PayPalParser
extends BookingParser {
    private static final List<String> COLUMN_NAME = List.of("Name");
    private static final List<String> COLUMN_EMAIL = List.of("From Email Address", "Absender E-Mail-Adresse");
    private static final List<String> COLUMN_DATE = List.of("Date", "Datum");
    private static final List<String> COLUMN_TIME = List.of("Time", "Uhrzeit");
    private static final List<String> COLUMN_TIMEZONE = List.of("TimeZone", "Zeitzone");
    private static final List<String> COLUMN_AMOUNT = List.of("Gross", "Brutto");
    private static final List<String> COLUMN_FEE = List.of("Fee", "Entgelt");
    private static final List<String> COLUMN_STATUS = List.of("Status");
    private static final List<String> COLUMN_CURRENCY = List.of("Currency", "W\u00e4hrung");

    protected <T extends Closeable> PayPalParser(CSVParser csvParser, T input, String revenueId, String expenseId, String balanceId) {
        super(csvParser, List.of(COLUMN_NAME, COLUMN_EMAIL, COLUMN_DATE, COLUMN_TIME, COLUMN_TIMEZONE, COLUMN_AMOUNT, COLUMN_FEE, COLUMN_STATUS, COLUMN_CURRENCY), input, expenseId, revenueId, balanceId);
    }

    @Override
    public List<Entry> parse() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (CSVRecord record : this.csvParser) {
            String status = this.getValue(record, COLUMN_STATUS);
            if (status == null || !status.equalsIgnoreCase("Completed") && !status.equalsIgnoreCase("Refunded")) continue;
            String timeZone = this.getValue(record, COLUMN_TIMEZONE);
            if (!timeZone.equals("CET") && !timeZone.equals("CEST")) {
                error.appendLine(new Error.Message("Warning: Timezone " + timeZone + " is not supported: " + this.getValue(record, COLUMN_NAME) + " " + this.getValue(record, COLUMN_EMAIL), "Warnung: Zeitzone " + timeZone + " wird nicht unterst\u00fctzt: " + this.getValue(record, COLUMN_NAME) + " " + this.getValue(record, COLUMN_EMAIL)));
            }
            Entry entry = new Entry(this.revenueId, this.expenseId, this.balanceId, this.getValue(record, COLUMN_DATE), this.getValue(record, COLUMN_NAME) + " " + this.getValue(record, COLUMN_EMAIL), this.getValue(record, COLUMN_AMOUNT), Float.toString(Math.abs(Float.parseFloat(this.getValue(record, COLUMN_FEE)))), this.getValue(record, COLUMN_CURRENCY), this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE));
            entries.add(entry);
        }
        return entries;
    }
}

