/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.bookingimport.parser;

import com.cashctrl.bookingimport.Entry;
import com.cashctrl.bookingimport.Error;
import com.cashctrl.bookingimport.parser.BookingParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class SumUpParser
extends BookingParser {
    private static final List<String> COLUMN_DESCRIPTION = List.of("Description", "Beschreibung");
    private static final List<String> COLUMN_DATE = List.of("Date", "Datum");
    private static final List<String> COLUMN_AMOUNT = List.of("Total amount", "Betrag inkl. MwSt.");
    private static final List<String> COLUMN_FEE = List.of("Fee", "Geb\u00fchr");
    private static final List<String> COLUMN_TYPE = List.of("Transaction Type", "Zahlungsart");
    private static final List<String> COLUMN_STATUS = List.of("Status");

    protected <T extends Closeable> SumUpParser(CSVParser csvParser, T input, String revenueId, String expenseId, String balanceId) {
        super(csvParser, List.of(COLUMN_DESCRIPTION, COLUMN_DATE, COLUMN_AMOUNT, COLUMN_FEE, COLUMN_TYPE, COLUMN_STATUS), input, expenseId, revenueId, balanceId);
    }

    @Override
    public List<Entry> parse() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (CSVRecord record : this.csvParser) {
            boolean isRefund = this.isRefund(record);
            if (record == null || !isRefund && !this.isValidTransaction(record)) continue;
            try {
                String fee = isRefund ? "0.0" : this.getValue(record, COLUMN_FEE);
                entries.add(new Entry(this.revenueId, this.expenseId, this.balanceId, this.getValue(record, COLUMN_DATE), this.getValue(record, COLUMN_DESCRIPTION), this.getValue(record, COLUMN_AMOUNT), fee, null, this.getValue(record, this.METADATA_COLUMN_CUSTOMER), this.getValue(record, this.METADATA_COLUMN_INVOICE)));
            }
            catch (Exception e) {
                error.appendLine(new Error.Message("Error: Failed to parse amount values" + (String)(error.getMode().equals((Object)Error.Mode.Full) ? ": " + e : "."), "Fehler: Beim parsen der Zeit" + (String)(error.getMode().equals((Object)Error.Mode.Full) ? ": " + e : ".")));
            }
        }
        return entries;
    }

    private boolean isRefund(CSVRecord record) {
        String type = this.getValue(record, COLUMN_TYPE);
        return type.equals("Refund") || type.equals("R\u00fcckerstattung");
    }

    private boolean isValidTransaction(CSVRecord record) {
        String status = this.getValue(record, COLUMN_STATUS);
        return status.equals("Successful") || status.equals("Erfolgreich");
    }
}

