package com.cashctrl.bookingimport;

/**
 * Journal Entry data storage.
 * @param revenueId revenue account id in CashCtrl
 * @param expenseId expense account id in CashCtrl
 * @param balanceId balance account id in CashCtrl
 * @param date the transaction date
 * @param description the transaction description / title
 * @param amount transaction amount
 * @param fee transaction fee amount
 * @param currency transaction currency
 * @param customerNr person number in CashCtrl
 * @param referenceNr transaction reference
 */
public record Entry(String revenueId, String expenseId, String balanceId,
                    String date, String description, String amount, String fee, String currency,
                    String customerNr, String referenceNr) {
}