<%@ page contentType="text/html; charset=UTF-8" import="static com.cashctrl.bookingimport.web.WebUtils.*" %>

<%
    setCookie(response, "lang", "de");
%>

<!doctype html>
<html lang="de">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="../resources/cashctrl-favicon.png"/>
    <title>CashCtrl - Buchung Import</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-0evHe/X+R7YkIZDRvuzKMRqM+OrBnVFBL6DOitfPri4tjfHxaWutUpFmBp4vmVor" crossorigin="anonymous">
    <link href="../css/bookingimport-style.css" rel="stylesheet">
</head>

<body class="bg-light">
<div class="container cc-container">
    <header>
        <div class="py-4 text-center">
            <a href="https://cashctrl.com/">
                <img class="cc-logo" src="../resources/cashctrl-logo.png" alt="">
            </a>
            <h1>Buchung Import</h1>
        </div>
    </header>
    <main>
        <div <%=session.getAttribute("alert-type") == null ? "hidden" : ""%>
                class="alert alert-<%=session.getAttribute("alert-type")%> alert-dismissible fade show">
            <strong><%=session.getAttribute("alert-head")%>
            </strong><br><%=session.getAttribute("alert-message")%>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <div>
            <form action="import" enctype="multipart/form-data" method="post">
                <div class="row g-1">
                    <h4 class="mb-3">Organisation</h4>
                    <div class="col-sm-6">
                        <label for="organisationName" class="form-label">Name</label>
                        <input name="organisationName" type="text" class="form-control" id="organisationName"
                               placeholder="z. B. muster-organisation"
                               value="<%=getCookieValue(request, "organisationName")%>" required>
                    </div>
                    <div class="col-sm-6">
                        <label for="organisationKey" class="form-label">API Schlüssel</label>
                        <input name="organisationKey" type="text" class="form-control" id="organisationKey"
                               value="" required>
                    </div>
                    <hr class="my-3">
                    <h4 class="mb-3">Konten</h4>
                    <div class="col-sm-4">
                        <label for="revenue" class="form-label">Ertrag</label>
                        <input name="revenue" type="number" class="form-control" id="revenue" placeholder="z. B. 3400"
                               value="<%=getCookieValue(request, "revenue")%>" min="0.00" step="0.01" required>
                    </div>
                    <div class="col-sm-4">
                        <label for="expense" class="form-label">Aufwand</label>
                        <input name="expense" type="number" class="form-control" id="expense" placeholder="z. B. 4400"
                               value="<%=getCookieValue(request, "expense")%>" min="0.00" step="0.01" required>
                    </div>
                    <div class="col-sm-4">
                        <label for="balance" class="form-label">Bilanz</label>
                        <input name="balance" type="number" class="form-control" id="balance" placeholder="z. B. 1101"
                               value="<%=getCookieValue(request, "balance")%>" min="0.00" step="0.01" required>
                    </div>
                    <hr class="my-3">
                    <h4 class="mb-3">Metadaten</h4>
                    <div class="col-sm-6">
                        <label for="invoiceField" class="form-label">Feld Rechnungsnummer</label>
                        <input name="invoiceField" type="text" class="form-control" id="invoiceField"
                               placeholder="z. B. RechnungNr"
                               value="<%=getCookieValue(request, "invoiceField")%>">
                    </div>
                    <div class="col-sm-6">
                        <label for="customerField" class="form-label">Feld Kundennummer</label>
                        <input name="customerField" type="text" class="form-control" id="customerField"
                               placeholder="z. B. KundenNr"
                               value="<%=getCookieValue(request, "customerField")%>">
                    </div>
                    <hr class="my-3">
                    <h4 class="mb-3">CSV</h4>
                    <div class="col-sm-12">
                        <label for="csvFile" class="form-label">Stripe, PayPal, SumUp und Payrexx</label>
                        <input class="form-control custom-file-input" id="csvFile" name="csvFile" multiple required type="file"/>
                    </div>
                    <div class="col-sm-12">
                        <div class="cc-import-button">
                            <button name="bookingImport" class="w-50 btn btn-primary" type="submit" value="submit">Import</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </main>
    <footer class="my-5 pt-2 text-muted text-center text-small">
        <a class="mb-1" href="../en/bookingimport.jsp">Englisch</a>
        <p class="mb-1">Buchung Import v2.0</p>
        <p class="mb-1">&copy; 2013 - 2022 CashCtrl AG</p>
    </footer>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-pprn3073KE6tl6bjs2QrFaJGz5/SUsLqktiwsUTF55Jfv3qYSDhgCecCxMW52nD2" crossorigin="anonymous"></script>
</body>

</html>
<% session.setAttribute("alert-type", null); %>