package com.cashctrl.bookingimport;

import java.util.Base64;

/**
 * Represents an organization
 * @author Silian Barlogis
 */
public class Organization {

    /**
     * Organization domain <b><a href="https://myOrg.cashctrl.com">https://myOrg.cashctrl.com</a></b>
     */
    private final String url;

    /**
     * Organization basic authorization with API kay
     */
    private final String authorization;

    /**
     * Organization raw name
     */
    private final String name;

    /**
     * Organization constructor
     * @param name organization name
     * @param key organization key
     */
    public Organization(String name, String key) {
        this.name = name;
        if (name.contains("https://") || name.contains("http://")) {
            url = name;
        } else {
            url = "https://" + name + ".cashctrl.com";
        }

        authorization = "Basic " + Base64.getEncoder().encodeToString((key + ":").getBytes());
    }

    public String getUrl() {
        return url;
    }

    public String getAuthorization() {
        return authorization;
    }

    @SuppressWarnings("unused")
    public String getName() {
        return name;
    }
}