/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLI {
    private CommandLine cmd;

    public boolean parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            this.printHelp();
            return false;
        }
        try {
            DefaultParser parser = new DefaultParser();
            this.cmd = parser.parse(this.getOptions(), args);
            if (this.cmd != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            System.out.print("Failed to parse the arguments! " + String.valueOf(parseException));
        }
        return false;
    }

    public boolean wannaSeeHelp() {
        return this.cmd.hasOption("h") || this.cmd.hasOption("help");
    }

    public void printHelp() {
        new HelpFormatter().printHelp("CashCtrl - orgsync", this.getOptions());
    }

    public boolean validateArguments() {
        String fsm;
        if (this.isArgumentValid("orga") || this.isArgumentValid("keya") || this.isArgumentValid("orgb") || this.isArgumentValid("keyb")) {
            return false;
        }
        if (!this.cmd.hasOption("p") && !this.cmd.hasOption("a")) {
            System.out.println("error: you need to set -p (person), -a (article)");
            return false;
        }
        if (this.cmd.hasOption("fsm") && ((fsm = this.cmd.getOptionValue("fsm")) == null || !fsm.equalsIgnoreCase("none") && !fsm.equalsIgnoreCase("all") && !fsm.equalsIgnoreCase("onlyAttached"))) {
            System.out.println("error: " + fsm + " is not a file synchronization mode use 'all', 'none' or 'onlyAttached'");
            return false;
        }
        if (this.cmd.hasOption("lsd")) {
            String lsd = this.cmd.getOptionValue("lsd");
            try {
                long l = Long.parseLong(lsd);
            }
            catch (Exception e) {
                System.out.println("error: " + lsd + " is not a number!");
                return false;
            }
        }
        return true;
    }

    public HashMap<String, String> parseFilter(String filter) {
        String[] options;
        if (this.isArgumentValid(filter)) {
            return null;
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        String value = this.cmd.getOptionValue(filter);
        for (String option : options = value.split(" ")) {
            String[] pairs = option.split("=");
            if (pairs.length < 2) continue;
            filters.put(pairs[0], pairs[1]);
        }
        return filters;
    }

    public boolean has(String option) {
        return this.cmd.hasOption(option);
    }

    public String get(String option) {
        return this.cmd.getOptionValue(option);
    }

    private boolean isArgumentValid(String arg) {
        if (!this.cmd.hasOption(arg)) {
            System.out.println("error: " + arg + " is not present.");
            return true;
        }
        String value = this.cmd.getOptionValue(arg);
        if (value == null || value.isEmpty()) {
            System.out.println("error: " + arg + " has no subsequent value");
            return true;
        }
        return false;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display help");
        options.addOption("p", false, "synchronize people");
        options.addOption("a", false, "synchronize articles");
        options.addOption("orga", true, "organization alpha");
        options.addOption("orgb", true, "organization beta");
        options.addOption("keya", true, "key to access organization alpha");
        options.addOption("keyb", true, "key to access organization beta");
        options.addOption("pf", true, "person filter: if you would like to synchronize all people which are employees and active use the following: \"category=employees onlyActive=true\"");
        options.addOption("af", true, "article filter: if you would like to synchronize all articles which are services and active use the following: \"category=services onlyActive=true\"");
        options.addOption("fsm", true, "file synchronization mode: possible values 'none', 'all' or 'onlyAttached', defaults to 'onlyAttached'.");
        options.addOption("lsd", true, "last synchronization delta - the time, in milliseconds, that must elapse since the last synchronization and last edited record before it is synchronized again, defaults to 10 seconds.");
        return options;
    }
}

