/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.File;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Attachment
extends SyncObject {
    protected final File file;
    protected final String updateAttachmentsEndpoint;

    protected Attachment(Organization alphaOrganization, Organization betaOrganization, String listEndpoint, String readEndpoint, String createEndpoint, String updateEndpoint, String updateAttachmentsEndpoint, String equalProperty, String dependencyProperty) {
        super(alphaOrganization, betaOrganization, listEndpoint, readEndpoint, createEndpoint, updateEndpoint, equalProperty, dependencyProperty);
        this.updateAttachmentsEndpoint = updateAttachmentsEndpoint;
        this.file = File.first(alphaOrganization, betaOrganization);
    }

    protected boolean attach(int recordId, List<Integer> fileIds, Organization organization) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", Integer.toString(recordId));
        StringBuilder filesStr = new StringBuilder();
        fileIds.forEach(fileId -> filesStr.append(fileId).append(','));
        data.put("fileIds", filesStr.toString());
        HttpResponse<String> response = this.http.post(organization, this.updateAttachmentsEndpoint, data, HttpResponse.BodyHandlers.ofString());
        return this.checkResponse(response, null, "update attachment");
    }

    protected void updateAttachments(SyncData syncData, Organization targetOrganization) {
        JsonObject srcDetails = syncData.sourceDetails();
        JsonObject target = syncData.target();
        if (!this.has(srcDetails, "attachments") && target.has("id")) {
            return;
        }
        JsonArray attachments = srcDetails.get("attachments").getAsJsonArray();
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        ArrayList<Integer> files = new ArrayList<Integer>();
        for (JsonElement a : attachments) {
            JsonObject attachment = (JsonObject)a;
            if (!this.has(attachment, "fileId") || !this.has(attachment, "name")) continue;
            JsonObject equalFile = this.file.equivalent(attachment.get("name").getAsString(), this.file.list(targetOrganization));
            if (!this.has(equalFile, "id") || !this.has(equalFile, "name")) {
                System.out.println("error: failed to update attachment, could not find equivalent file inside target organization: " + targetOrganization.name() + " file name: " + attachment.get("name").getAsString());
                continue;
            }
            files.add(equalFile.get("id").getAsInt());
        }
        if (!this.attach(target.get("id").getAsInt(), files, targetOrganization)) {
            System.out.println("error: failed to attach " + String.valueOf(files) + " to " + String.valueOf(target) + " in " + String.valueOf(targetOrganization));
        }
    }
}

