/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;

public class Currency
extends SyncObject {
    public Currency(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/currency/list.json", "/api/v1/currency/read.json", "/api/v1/currency/create.json", "/api/v1/currency/update.json", "code", "currencyId");
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject currency = syncData.source();
        List<SyncObject.Parameter> fields = List.of(new SyncObject.Parameter("code", currency, SyncObject.DataType.STRING), new SyncObject.Parameter("description", currency, SyncObject.DataType.STRING), new SyncObject.Parameter("isDefault", currency, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("rate", currency, SyncObject.DataType.DOUBLE));
        return this.parametrizeParams(fields);
    }

    @Override
    public boolean isValid(JsonObject currency) {
        return this.has(currency, "id") && this.has(currency, "code") && this.has(currency, "lastUpdated");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject currency) {
        if (this.has(currency, "id")) {
            info.append(" id: ").append(currency.get("id"));
        }
        if (this.has(currency, "name")) {
            info.append(" name: ").append(currency.get("name"));
        }
        if (this.has(currency, "description")) {
            info.append(" description: ").append(currency.get("description"));
        }
    }
}

