/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Organization;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;

public final class HttpMethods {
    private static final int BURST_FIRE = 100;
    private static final int THROTTLE = 10;
    private static final int WAIT = 1000;
    private static HttpMethods instance;
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).proxy(ProxySelector.getDefault()).build();
    private int requestCounter = 0;
    private Duration requestDuration = Duration.ofSeconds(20L);

    private HttpMethods() {
    }

    public static HttpMethods instance() {
        if (instance == null) {
            instance = new HttpMethods();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> HttpResponse<T> get(Organization organization, String uri, HashMap<String, String> parameter, HttpResponse.BodyHandler<T> handle) {
        StringBuilder encodedParameter = new StringBuilder();
        if (parameter != null && !parameter.isEmpty()) {
            encodedParameter.append("?");
            parameter.forEach((key, value) -> {
                encodedParameter.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                if (parameter.size() > 1) {
                    encodedParameter.append("&");
                }
            });
        }
        URI url = URI.create(organization.url() + uri + String.valueOf(encodedParameter));
        HttpRequest request = HttpRequest.newBuilder().uri(url).timeout(this.requestDuration).header("Authorization", organization.authorization()).GET().build();
        this.maybeDelayRequest();
        ++this.requestCounter;
        HttpResponse<T> response = null;
        try {
            response = this.client.send(request, handle);
        }
        catch (IOException | IllegalStateException | InterruptedException exception) {
            System.out.print("error: exception: " + String.valueOf(exception));
        }
        finally {
            if (response == null || response.statusCode() != 200) {
                System.out.println("GET request failed!");
                if (response != null) {
                    this.printResponse(response);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> HttpResponse<T> post(Organization organization, String uri, HashMap<String, String> data, HttpResponse.BodyHandler<T> handle) {
        StringBuilder encodedData = new StringBuilder();
        if (data != null) {
            data.forEach((key, value) -> {
                if (!encodedData.isEmpty()) {
                    encodedData.append("&");
                }
                encodedData.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
            });
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(organization.url() + uri)).timeout(this.requestDuration).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", organization.authorization()).POST(HttpRequest.BodyPublishers.ofString(encodedData.toString())).build();
        this.maybeDelayRequest();
        ++this.requestCounter;
        HttpResponse<T> response = null;
        try {
            response = this.client.send(request, handle);
        }
        catch (IOException | IllegalStateException | InterruptedException exception) {
            System.out.print("error: exception: " + String.valueOf(exception));
        }
        finally {
            if (response == null || response.statusCode() != 200) {
                System.out.println("POST request failed!");
                if (response != null) {
                    this.printResponse(response);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> HttpResponse<T> put(String endpoint, String mime, byte[] data, HttpResponse.BodyHandler<T> handle) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endpoint)).timeout(Duration.ofSeconds(this.requestCounter)).header("Content-Type", mime.isEmpty() ? "application/octet-stream" : mime).PUT(HttpRequest.BodyPublishers.ofByteArray(data)).build();
        this.maybeDelayRequest();
        ++this.requestCounter;
        HttpResponse<T> response = null;
        try {
            response = this.client.send(request, handle);
        }
        catch (IOException | IllegalStateException | InterruptedException exception) {
            System.out.print("error: exception: " + String.valueOf(exception));
        }
        finally {
            if (response == null || response.statusCode() != 200) {
                System.out.println("PUT request failed!");
                if (response != null) {
                    this.printResponse(response);
                }
            }
        }
        return response;
    }

    private <T> void printResponse(HttpResponse<T> response) {
        System.out.println("Status: " + response.statusCode());
        System.out.println("Body: " + String.valueOf(response.body()));
    }

    private void maybeDelayRequest() {
        if (this.requestCounter >= 95) {
            try {
                Thread.sleep(1000L);
                this.requestCounter -= 10;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public Duration getRequestDuration() {
        return this.requestDuration;
    }

    public void setRequestDuration(Duration requestDuration) {
        this.requestDuration = requestDuration;
    }
}

