/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.FileCategory;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class File
extends SyncObject {
    private static File instance;
    protected final String prepareEndpoint;
    protected final String downloadEndpoint;
    protected final String deleteEndpoint;
    private final FileCategory fileCategory;
    private FileSyncMode fileSyncMode = FileSyncMode.OnlyAttached;

    protected File(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/file/list.json", "/api/v1/file/read.json", "/api/v1/file/create.json", "/api/v1/file/update.json", "name", "");
        this.prepareEndpoint = "/api/v1/file/prepare.json";
        this.downloadEndpoint = "/api/v1/file/get";
        this.deleteEndpoint = "/api/v1/file/delete.json";
        this.fileCategory = new FileCategory(alphaOrganization, betaOrganization);
    }

    public static File instance() {
        return instance;
    }

    public static File first(Organization alphaOrganization, Organization betaOrganization) {
        if (instance == null) {
            instance = new File(alphaOrganization, betaOrganization);
        }
        return instance;
    }

    protected byte[] download(int fileId, Organization organization) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("id", Integer.toString(fileId));
        HttpResponse<byte[]> response = this.http.get(organization, this.downloadEndpoint, filter, HttpResponse.BodyHandlers.ofByteArray());
        if (response != null && response.statusCode() == 200) {
            return response.body();
        }
        System.out.println("error: failed to download file from " + organization.name());
        return null;
    }

    protected JsonObject prepare(JsonObject metadata, Organization organization) {
        JsonObject writeUrl;
        JsonArray writeUrls;
        if (!this.has(metadata, "mimeType") || !this.has(metadata, "name")) {
            System.out.println("error: failed to prepare, critical metadata is missing!");
            return null;
        }
        JsonArray files = new JsonArray();
        JsonObject file = new JsonObject();
        file.addProperty("mimeType", metadata.get("mimeType").getAsString());
        file.addProperty("name", metadata.get("name").getAsString());
        if (this.has(metadata, "categoryId")) {
            file.addProperty("categoryId", Integer.toString(metadata.get("categoryId").getAsInt()));
        }
        if (this.has(metadata, "size")) {
            file.addProperty("size", Integer.toString(metadata.get("size").getAsInt()));
        }
        files.add(file);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("files", files.toString());
        HttpResponse<String> response = this.http.post(organization, this.prepareEndpoint, data, HttpResponse.BodyHandlers.ofString());
        if (!this.checkResponse(response, null, "prepare file")) {
            return null;
        }
        JsonObject body = this.gson.fromJson(response.body(), JsonObject.class);
        if (this.has(body, "data") && (writeUrls = body.getAsJsonArray("data")) != null && !writeUrls.isEmpty() && this.has(writeUrl = writeUrls.get(0).getAsJsonObject(), "fileId") && this.has(writeUrl, "writeUrl")) {
            return writeUrl;
        }
        System.out.println("error: failed to prepare file, response contains no write urls");
        return null;
    }

    protected boolean delete(int fileId, boolean permanent, Organization organization) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ids", Integer.toString(fileId));
        data.put("force", Boolean.toString(permanent));
        HttpResponse<String> response = this.http.post(organization, this.deleteEndpoint, data, HttpResponse.BodyHandlers.ofString());
        return this.checkResponse(response, null, "delete file");
    }

    protected boolean isAttached(JsonObject file) {
        return this.has(file, "isAttached") && file.get("isAttached").getAsBoolean();
    }

    @Override
    public SyncObject.State synchronize() {
        this.http.setRequestDuration(Duration.ofSeconds(20L));
        System.out.println("--------- synchronize: file categories---------");
        switch (this.fileCategory.synchronize()) {
            case Success: {
                System.out.println("success: file categories synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no file categories to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize file categories!");
            }
        }
        this.http.setRequestDuration(Duration.ofMinutes(2L));
        System.out.println("--------- synchronize: files ---------");
        return super.synchronize();
    }

    @Override
    protected JsonArray list(HashMap<String, String> filter, Organization organization) {
        if (filter != null && !filter.containsKey("limit")) {
            filter.put("limit", Integer.toString(99999));
        }
        return super.list(filter, organization);
    }

    @Override
    protected boolean create(SyncData syncData, Organization targetOrganization, Organization sourceOrganization) {
        if (this.has(syncData.source(), "categoryId")) {
            this.fileCategory.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
        JsonObject source = syncData.source();
        if (this.fileSyncMode.equals((Object)FileSyncMode.OnlyAttached) && !this.isAttached(source)) {
            return true;
        }
        JsonObject writeUrl = this.prepare(source, targetOrganization);
        byte[] file = this.download(source.get("id").getAsInt(), sourceOrganization);
        if (file == null || writeUrl == null) {
            return false;
        }
        HttpResponse<String> response = this.http.put(writeUrl.get("writeUrl").getAsString(), this.has(writeUrl, "mimeType") ? writeUrl.get("mimeType").getAsString() : "", file, HttpResponse.BodyHandlers.ofString());
        if (response == null || response.statusCode() != 200) {
            System.out.println("error: failed to write file to authenticated url");
            return false;
        }
        SyncData fileData = new SyncData(source);
        HashMap<String, String> data = this.parametrize(fileData);
        data.put("id", Integer.toString(writeUrl.get("fileId").getAsInt()));
        return this.checkResponse(this.http.post(targetOrganization, this.createEndpoint, data, HttpResponse.BodyHandlers.ofString()), fileData, "create file");
    }

    @Override
    protected boolean update(SyncData syncData, Organization targetOrganization, Organization sourceOrganization) {
        JsonObject source = syncData.source();
        JsonObject target = syncData.target();
        if (this.fileSyncMode.equals((Object)FileSyncMode.OnlyAttached) && !this.isAttached(source)) {
            return true;
        }
        if (source.get("size").getAsInt() != target.get("size").getAsInt()) {
            byte[] sourceBytes = this.download(source.get("id").getAsInt(), sourceOrganization);
            byte[] targetBytes = this.download(target.get("id").getAsInt(), targetOrganization);
            if (sourceBytes == null || targetBytes == null) {
                return false;
            }
            if (!Arrays.equals(sourceBytes, targetBytes)) {
                return this.delete(target.get("id").getAsInt(), false, targetOrganization) && this.create(syncData, targetOrganization, sourceOrganization);
            }
        }
        return super.update(syncData, targetOrganization, sourceOrganization);
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject file = syncData.source();
        List<SyncObject.Parameter> fields = List.of(new SyncObject.Parameter("id", file, SyncObject.DataType.STRING), new SyncObject.Parameter("name", file, SyncObject.DataType.STRING), new SyncObject.Parameter("custom", file, SyncObject.DataType.STRING), new SyncObject.Parameter("description", file, SyncObject.DataType.STRING), new SyncObject.Parameter("notes", file, SyncObject.DataType.STRING), new SyncObject.Parameter("categoryId", file, SyncObject.DataType.INT));
        return this.parametrizeParams(fields);
    }

    public FileSyncMode getFileSyncMode() {
        return this.fileSyncMode;
    }

    public void setFileSyncMode(FileSyncMode fileSyncMode) {
        this.fileSyncMode = fileSyncMode;
    }

    @Override
    protected boolean isValid(JsonObject file) {
        return this.has(file, "id") && this.has(file, "isAttached") && this.has(file, "name") && this.has(file, "mimeType") && this.has(file, "size");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject file) {
        if (this.has(file, "id")) {
            info.append(" id: ").append(file.get("id"));
        }
        if (this.has(file, "name")) {
            info.append(" name: ").append(file.get("name"));
        }
        if (this.has(file, "mimeType")) {
            info.append(" mimeType: ").append(file.get("mimeType"));
        }
        if (this.has(file, "isAttached")) {
            info.append(" isAttached: ").append(file.get("isAttached"));
        }
        if (this.has(file, "description")) {
            info.append(" description: ").append(file.get("description"));
        }
    }

    public static enum FileSyncMode {
        OnlyAttached,
        All,
        None;

    }
}

