/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.util.HashMap;

public abstract class Category
extends SyncObject {
    protected final String treeEndpoint;

    protected Category(Organization alphaOrganization, Organization betaOrganization, String listEndpoint, String readEndpoint, String createEndpoint, String updateEndpoint, String treeEndpoint) {
        super(alphaOrganization, betaOrganization, listEndpoint, readEndpoint, createEndpoint, updateEndpoint, "name", "categoryId");
        this.treeEndpoint = treeEndpoint;
    }

    @Override
    public SyncObject.State synchronize() {
        int alphaParentId = -1;
        int betaParentId = -1;
        if (this.filter != null && this.filter.containsKey("category")) {
            JsonObject alphaCategory = this.equivalent((String)this.filter.get("category"), this.list(this.alphaOrganization));
            JsonObject betaCategory = this.equivalent((String)this.filter.get("category"), this.list(this.betaOrganization));
            if (this.isValid(alphaCategory) && this.isValid(betaCategory)) {
                alphaParentId = alphaCategory.get("id").getAsInt();
                betaParentId = betaCategory.get("id").getAsInt();
            } else {
                System.out.println("error: the category " + (String)this.filter.get("category") + " does not exist in both organizations");
                return SyncObject.State.Error;
            }
        }
        JsonArray alphaTree = this.tree(alphaParentId, this.alphaOrganization);
        JsonArray betaTree = this.tree(betaParentId, this.betaOrganization);
        if (alphaTree == null || betaTree == null) {
            return SyncObject.State.Error;
        }
        if (alphaTree.isEmpty() && betaTree.isEmpty()) {
            return SyncObject.State.NoChange;
        }
        return this.synchronize(alphaTree, betaTree, alphaParentId, betaParentId);
    }

    protected SyncObject.State synchronize(JsonArray alphaCategories, JsonArray betaCategories, int alphaParentId, int betaParentId) {
        JsonObject betaCategory;
        for (int alphaIdx = 0; alphaIdx < alphaCategories.size(); ++alphaIdx) {
            JsonObject alphaCategory = alphaCategories.get(alphaIdx).getAsJsonObject();
            if (!this.isValid(alphaCategory)) continue;
            boolean existsInBeta = false;
            for (int betaIdx = 0; betaIdx < betaCategories.size(); ++betaIdx) {
                long betaTime;
                betaCategory = betaCategories.get(betaIdx).getAsJsonObject();
                if (!this.isValid(betaCategory) || !this.equals(alphaCategory, betaCategory)) continue;
                existsInBeta = true;
                long alphaTime = this.lastUpdated(alphaCategory);
                if (alphaTime == (betaTime = this.lastUpdated(betaCategory))) continue;
                if (alphaTime > betaTime && alphaTime > this.alphaOrganization.lastSynchronized()) {
                    this.updateCategory(betaParentId, alphaCategory, betaCategory, this.betaOrganization);
                    continue;
                }
                if (betaTime <= alphaTime || betaTime <= this.betaOrganization.lastSynchronized()) continue;
                this.updateCategory(alphaParentId, betaCategory, alphaCategory, this.alphaOrganization);
            }
            if (existsInBeta) continue;
            this.createCategory(betaParentId, alphaCategory, this.betaOrganization);
        }
        for (int betaIdx = 0; betaIdx < betaCategories.size(); ++betaIdx) {
            JsonObject categoryBeta = betaCategories.get(betaIdx).getAsJsonObject();
            if (!this.isValid(categoryBeta)) continue;
            boolean existsInAlpha = false;
            for (int alphaIdx = 0; alphaIdx < alphaCategories.size(); ++alphaIdx) {
                JsonObject categoryAlpha = alphaCategories.get(alphaIdx).getAsJsonObject();
                if (!this.isValid(categoryAlpha) || !this.equals(categoryAlpha, categoryBeta)) continue;
                existsInAlpha = true;
            }
            if (existsInAlpha) continue;
            this.createCategory(alphaParentId, categoryBeta, this.alphaOrganization);
        }
        JsonArray newAlphaCategories = this.tree(alphaParentId, this.alphaOrganization);
        JsonArray newBetaCategories = this.tree(betaParentId, this.betaOrganization);
        if (newAlphaCategories.size() != newBetaCategories.size()) {
            System.out.println("error: failed to sync categories unknown cause");
            return SyncObject.State.Error;
        }
        for (int alphaIdx = 0; alphaIdx < newAlphaCategories.size(); ++alphaIdx) {
            JsonObject alphaCategory = newAlphaCategories.get(alphaIdx).getAsJsonObject();
            if (!this.isValid(alphaCategory) || !this.has(alphaCategory, "leaf") || !this.isValid(betaCategory = this.equivalent(alphaCategory, newBetaCategories)) || !this.has(betaCategory, "leaf") || this.isLeaf(alphaCategory) && this.isLeaf(betaCategory)) continue;
            JsonArray alphaTree = this.has(alphaCategory, "data") ? alphaCategory.get("data").getAsJsonArray() : new JsonArray();
            JsonArray betaTree = this.has(betaCategory, "data") ? betaCategory.get("data").getAsJsonArray() : new JsonArray();
            this.synchronize(alphaTree, betaTree, alphaCategory.get("id").getAsInt(), betaCategory.get("id").getAsInt());
        }
        return SyncObject.State.Success;
    }

    private void createCategory(int targetParentId, JsonObject sourceCategory, Organization targetOrganization) {
        SyncData syncData;
        if (this.has(sourceCategory, "parentId")) {
            sourceCategory.addProperty("parentId", targetParentId);
        }
        if (!this.create(syncData = new SyncData(sourceCategory), targetOrganization, null)) {
            System.out.println("error: failed to update category in organization: " + targetOrganization.name());
        }
    }

    private void updateCategory(int targetParentId, JsonObject sourceCategory, JsonObject targetCategory, Organization targetOrganization) {
        SyncData syncData;
        if (this.has(sourceCategory, "parentId")) {
            sourceCategory.addProperty("parentId", targetParentId);
        }
        if (!this.update(syncData = new SyncData(sourceCategory, targetCategory), targetOrganization, null)) {
            System.out.println("error: failed to update category in organization: " + targetOrganization.name());
        }
    }

    protected boolean prepareFilter(HashMap<String, String> originalFilter, HashMap<String, String> alphaFilter, HashMap<String, String> betaFilter) {
        if (originalFilter != null && originalFilter.containsKey("category")) {
            JsonObject alphaCategory = this.equivalent(originalFilter.get("category"), this.list(this.alphaOrganization));
            JsonObject betaCategory = this.equivalent(originalFilter.get("category"), this.list(this.betaOrganization));
            if (this.isValid(alphaCategory) && this.isValid(betaCategory)) {
                alphaFilter.putAll(originalFilter);
                betaFilter.putAll(originalFilter);
                alphaFilter.put("categoryId", Integer.toString(alphaCategory.get("id").getAsInt()));
                betaFilter.put("categoryId", Integer.toString(betaCategory.get("id").getAsInt()));
                alphaFilter.remove("category");
                betaFilter.remove("category");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid(JsonObject category) {
        return this.has(category, "id") && this.has(category, "name") && this.has(category, "lastUpdated");
    }

    public JsonArray tree(int id, Organization organization) {
        HttpResponse<String> response;
        HashMap<String, String> params = new HashMap<String, String>();
        if (id != -1) {
            params.put("id", Integer.toString(id));
        }
        if ((response = this.http.get(organization, this.treeEndpoint, params, HttpResponse.BodyHandlers.ofString())) != null && response.statusCode() == 200) {
            JsonObject body = this.gson.fromJson(response.body(), JsonObject.class);
            return this.has(body, "data") ? body.get("data").getAsJsonArray() : null;
        }
        return null;
    }

    public boolean isLeaf(JsonObject category) {
        return category.get("leaf").getAsBoolean();
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject category) {
        if (this.has(category, "id")) {
            info.append(" id: ").append(category.get("id"));
        }
        if (this.has(category, "name")) {
            info.append(" name: ").append(category.get("name"));
        }
        if (this.has(category, "parentId")) {
            info.append(" parentId: ").append(category.get("parentId"));
        }
        if (this.has(category, "leaf")) {
            info.append(" leaf: ").append(category.get("leaf"));
        }
        if (this.has(category, "data")) {
            info.append(" data: ").append(category.get("data"));
        }
    }
}

