/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.HttpMethods;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class SyncObject {
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected final HttpMethods http = HttpMethods.instance();
    protected final Gson gson = new Gson();
    protected final Organization alphaOrganization;
    protected final Organization betaOrganization;
    protected final String listEndpoint;
    protected final String readEndpoint;
    protected final String createEndpoint;
    protected final String updateEndpoint;
    protected final String equalProperty;
    protected final String dependencyProperty;
    protected final int limit = 99999;
    protected HashMap<String, String> filter = null;

    protected SyncObject(Organization alphaOrganization, Organization betaOrganization, String listEndpoint, String readEndpoint, String createEndpoint, String updateEndpoint, String equalProperty, String dependencyProperty) {
        this.alphaOrganization = alphaOrganization;
        this.betaOrganization = betaOrganization;
        this.listEndpoint = listEndpoint;
        this.readEndpoint = readEndpoint;
        this.createEndpoint = createEndpoint;
        this.updateEndpoint = updateEndpoint;
        this.equalProperty = equalProperty;
        this.dependencyProperty = dependencyProperty;
    }

    public State synchronize() {
        JsonArray alphaObjects = this.list(this.alphaOrganization);
        JsonArray betaObjects = this.list(this.betaOrganization);
        if (alphaObjects == null || betaObjects == null) {
            return State.Error;
        }
        if (alphaObjects.isEmpty() && betaObjects.isEmpty()) {
            return State.NoChange;
        }
        for (int alphaIdx = 0; alphaIdx < alphaObjects.size(); ++alphaIdx) {
            SyncData syncData;
            JsonObject alphaObject = alphaObjects.get(alphaIdx).getAsJsonObject();
            if (!this.isValid(alphaObject)) continue;
            boolean existsInBeta = false;
            for (int betaIdx = 0; betaIdx < betaObjects.size(); ++betaIdx) {
                SyncData syncData2;
                long betaTime;
                JsonObject betaObject = betaObjects.get(betaIdx).getAsJsonObject();
                if (!this.isValid(betaObject) || !this.equals(alphaObject, betaObject)) continue;
                existsInBeta = true;
                long alphaTime = this.lastUpdated(alphaObject);
                if (alphaTime == (betaTime = this.lastUpdated(betaObject))) continue;
                if (alphaTime > betaTime && alphaTime > this.alphaOrganization.lastSynchronized()) {
                    syncData2 = new SyncData(alphaObject, betaObject);
                    if (this.update(syncData2, this.betaOrganization, this.alphaOrganization)) continue;
                    System.out.println("error: failed to update in organization: " + this.betaOrganization.name());
                    return State.Error;
                }
                if (betaTime <= alphaTime || betaTime <= this.betaOrganization.lastSynchronized() || this.update(syncData2 = new SyncData(betaObject, alphaObject), this.alphaOrganization, this.betaOrganization)) continue;
                System.out.println("error: failed to update in organization: " + this.alphaOrganization.name());
                return State.Error;
            }
            if (existsInBeta || this.create(syncData = new SyncData(alphaObject), this.betaOrganization, this.alphaOrganization)) continue;
            System.out.println("error: failed to create in organization: " + this.betaOrganization.name());
            return State.Error;
        }
        for (int betaIdx = 0; betaIdx < betaObjects.size(); ++betaIdx) {
            SyncData syncData;
            JsonObject betaObject = betaObjects.get(betaIdx).getAsJsonObject();
            boolean existsInAlpha = false;
            for (int alphaIdx = 0; alphaIdx < alphaObjects.size(); ++alphaIdx) {
                JsonObject alphaObject = alphaObjects.get(alphaIdx).getAsJsonObject();
                if (!this.equals(alphaObject, betaObject)) continue;
                existsInAlpha = true;
            }
            if (existsInAlpha || this.create(syncData = new SyncData(betaObject), this.alphaOrganization, this.betaOrganization)) continue;
            System.out.println("error: failed to create in organization: " + this.alphaOrganization.name());
            return State.Error;
        }
        return State.Success;
    }

    public void setFilter(HashMap<String, String> filter) {
        this.filter = filter;
    }

    protected JsonArray list(Organization organization) {
        return this.list(new HashMap<String, String>(), organization);
    }

    protected JsonArray list(HashMap<String, String> filter, Organization organization) {
        JsonObject body;
        HttpResponse<String> response = this.http.get(organization, this.listEndpoint, filter, HttpResponse.BodyHandlers.ofString());
        if (response != null && response.statusCode() == 200 && this.has(body = this.gson.fromJson(response.body(), JsonObject.class), "data")) {
            return body.get("data").getAsJsonArray();
        }
        return null;
    }

    protected JsonObject read(int id, Organization organization) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("id", Integer.toString(id));
        HttpResponse<String> response = this.http.get(organization, this.readEndpoint, parameter, HttpResponse.BodyHandlers.ofString());
        if (response != null && response.statusCode() == 200) {
            JsonObject body = this.gson.fromJson(response.body(), JsonObject.class);
            return this.has(body, "data") ? body.get("data").getAsJsonObject() : null;
        }
        return null;
    }

    protected boolean create(SyncData syncData, Organization targetOrganization, Organization sourceOrganization) {
        HashMap<String, String> data = this.parametrize(syncData);
        HttpResponse<String> response = this.http.post(targetOrganization, this.createEndpoint, data, HttpResponse.BodyHandlers.ofString());
        if (this.checkResponse(response, syncData, "create")) {
            syncData.target().addProperty("id", this.insertId(response));
            return true;
        }
        return false;
    }

    protected boolean update(SyncData syncData, Organization targetOrganization, Organization sourceOrganization) {
        if (this.has(syncData.target(), "id")) {
            HashMap<String, String> data = this.parametrize(syncData);
            data.put("id", Integer.toString(syncData.target().get("id").getAsInt()));
            HttpResponse<String> response = this.http.post(targetOrganization, this.updateEndpoint, data, HttpResponse.BodyHandlers.ofString());
            return this.checkResponse(response, syncData, "update");
        }
        System.out.println("error: the target has no id or is null");
        return false;
    }

    protected boolean checkResponse(HttpResponse<String> response, SyncData syncData, String action) {
        if (response == null || response.statusCode() != 200) {
            return false;
        }
        JsonObject jsonResponse = this.gson.fromJson(response.body(), JsonObject.class);
        if (this.has(jsonResponse, "success")) {
            if (jsonResponse.get("success").getAsBoolean()) {
                return true;
            }
            if (syncData != null) {
                System.out.println("error subject: " + this.getInfo(syncData, action));
            }
            if (this.has(jsonResponse, "errors")) {
                JsonArray errors = jsonResponse.get("errors").getAsJsonArray();
                for (int idx = 0; idx < errors.size(); ++idx) {
                    JsonObject error = errors.get(idx).getAsJsonObject();
                    System.out.println("field: " + (this.has(error, "field") ? error.get("field").getAsString() : "null"));
                    System.out.println("message: " + (this.has(error, "message") ? error.get("message").getAsString() : "null"));
                }
            }
            if (this.has(jsonResponse, "message")) {
                System.out.println("message: " + jsonResponse.get("message").getAsString());
            }
        }
        return false;
    }

    protected boolean has(JsonObject object, String property) {
        return object != null && object.has(property) && !object.get(property).isJsonNull();
    }

    protected int insertId(HttpResponse<String> response) {
        if (response == null || response.statusCode() != 200) {
            return -1;
        }
        JsonObject jsonResponse = this.gson.fromJson(response.body(), JsonObject.class);
        return this.has(jsonResponse, "insertId") ? jsonResponse.get("insertId").getAsInt() : -1;
    }

    protected long lastUpdated(JsonObject object) {
        try {
            String timeStr = object.get("lastUpdated").getAsString();
            return this.dateFormat.parse(timeStr).getTime();
        }
        catch (ParseException exception) {
            System.out.println("error: failed to parse date: " + String.valueOf(exception));
            return 0L;
        }
    }

    public long getLastEdited(Organization organization) {
        JsonObject obj;
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("sort", "lastUpdated");
        filter.put("dir", "DESC");
        filter.put("limit", "1");
        JsonArray records = this.list(filter, organization);
        if (records != null && !records.isEmpty() && (obj = records.get(0).getAsJsonObject()) != null && !obj.isJsonNull()) {
            return this.lastUpdated(obj);
        }
        if (records != null && records.isEmpty()) {
            return new Date().getTime();
        }
        System.out.println("error: failed to get last edited " + String.valueOf(this) + " in " + organization.name());
        return 0L;
    }

    protected JsonObject equivalent(JsonObject searchObject, JsonArray pool) {
        for (int idx = 0; idx < pool.size(); ++idx) {
            JsonObject obj = pool.get(idx).getAsJsonObject();
            if (!this.equals(searchObject, obj)) continue;
            return obj;
        }
        return null;
    }

    protected JsonObject equivalent(String searchValue, JsonArray pool) {
        for (int idx = 0; idx < pool.size(); ++idx) {
            JsonObject obj = pool.get(idx).getAsJsonObject();
            if (!this.has(obj, this.equalProperty) || !obj.get(this.equalProperty).getAsString().equals(searchValue)) continue;
            return obj;
        }
        return null;
    }

    protected void fixDependency(SyncData syncData, Organization sourceOrg, Organization targetOrg) {
        JsonObject equivalentObject;
        JsonObject source = syncData.source();
        JsonObject sourceObject = this.read(source.get(this.dependencyProperty).getAsInt(), sourceOrg);
        JsonArray targetObjects = this.list(targetOrg);
        if (this.has(sourceObject, this.equalProperty) && targetObjects != null && (equivalentObject = this.equivalent(sourceObject, targetObjects)) != null) {
            source.addProperty(this.dependencyProperty, equivalentObject.get("id").getAsInt());
            return;
        }
        if (targetObjects == null || targetObjects.isEmpty()) {
            System.out.println("error: no objects in organization: " + targetOrg.url());
        }
        System.out.println("error: failed to fix dependency " + this.dependencyProperty + " in: \n" + this.getInfo(syncData, "") + (String)(this.has(sourceObject, this.equalProperty) ? " \nCouldn't find: " + String.valueOf(sourceObject.get(this.equalProperty)) : ""));
        source.remove(this.dependencyProperty);
    }

    protected boolean equals(JsonObject alphaObject, JsonObject betaObject) {
        return this.has(alphaObject, this.equalProperty) && this.has(betaObject, this.equalProperty) && alphaObject.get(this.equalProperty).equals(betaObject.get(this.equalProperty));
    }

    protected abstract HashMap<String, String> parametrize(SyncData var1);

    protected HashMap<String, String> parametrizeParams(List<Parameter> fields) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Parameter f : fields) {
            if (f.source() == null || !this.has(f.source(), f.name())) continue;
            switch (f.type()) {
                case STRING: {
                    data.put(f.name(), f.source().get(f.name()).getAsString());
                    break;
                }
                case INT: {
                    data.put(f.name(), Integer.toString(f.source().get(f.name()).getAsInt()));
                    break;
                }
                case FLOAT: {
                    data.put(f.name(), Float.toString(f.source().get(f.name()).getAsFloat()));
                    break;
                }
                case DOUBLE: {
                    data.put(f.name(), Double.toString(f.source().get(f.name()).getAsDouble()));
                    break;
                }
                case BOOLEAN: {
                    data.put(f.name(), Boolean.toString(f.source().get(f.name()).getAsBoolean()));
                    break;
                }
                case JSON_ARRAY: {
                    data.put(f.name(), this.gson.toJson(f.source().get(f.name()).getAsJsonArray()));
                }
            }
        }
        return data;
    }

    protected String getInfo(SyncData syncData, String action) {
        StringBuilder info = new StringBuilder();
        if (!action.isBlank()) {
            info.append("ACTION: ").append(action).append("\n");
        }
        if (syncData.source() != null) {
            info.append("SOURCE: ");
            this.vitalInfo(info, syncData.source());
            info.append("\n");
        } else {
            info.append("SOURCE is null\n");
        }
        if (syncData.target() != null) {
            info.append("TARGET: ");
            this.vitalInfo(info, syncData.target());
        } else {
            info.append("TARGET is null");
        }
        return info.toString();
    }

    protected abstract boolean isValid(JsonObject var1);

    protected abstract void vitalInfo(StringBuilder var1, JsonObject var2);

    public static enum State {
        Success,
        NoChange,
        Error;

    }

    protected record Parameter(String name, JsonObject source, DataType type) {
    }

    protected static enum DataType {
        STRING,
        INT,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        JSON_ARRAY;

    }
}

