/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Article;
import com.cashctrl.orgsync.CLI;
import com.cashctrl.orgsync.File;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.Person;

public final class OrgSync {
    private static final CLI cli = new CLI();
    private static int synced = SynStep.Nothing.bit();
    private static Organization alphaOrganization = null;
    private static Organization betaOrganization = null;

    public static void main(String[] args) {
        if (!cli.parseArguments(args)) {
            return;
        }
        if (cli.wannaSeeHelp()) {
            cli.printHelp();
            return;
        }
        if (!cli.validateArguments()) {
            return;
        }
        alphaOrganization = new Organization(cli.get("orga"), cli.get("keya"));
        betaOrganization = new Organization(cli.get("orgb"), cli.get("keyb"));
        if (cli.has("lsd")) {
            long delta = Long.parseLong(cli.get("lsd"));
            alphaOrganization.lastSynchronizedDelta(delta);
            betaOrganization.lastSynchronizedDelta(delta);
        }
        OrgSync.synchronize();
        int value = SynStep.Nothing.bit;
        value = cli.has("p") && cli.has("a") ? (value |= SynStep.File.bit | SynStep.Person.bit | SynStep.Article.bit) : (cli.has("p") ? (value |= SynStep.File.bit | SynStep.Person.bit) : (value |= SynStep.File.bit | SynStep.Article.bit));
        if (synced == value) {
            alphaOrganization.updateLastSynchronized();
            betaOrganization.updateLastSynchronized();
        }
    }

    private static void synchronize() {
        Person person = new Person(alphaOrganization, betaOrganization);
        long personLastEditedAlpha = person.getLastEdited(alphaOrganization);
        long personLastEditedBeta = person.getLastEdited(betaOrganization);
        Article article = new Article(alphaOrganization, betaOrganization);
        long articleLastEditedAlpha = article.getLastEdited(alphaOrganization);
        long articleLastEditedBeta = article.getLastEdited(betaOrganization);
        if (personLastEditedAlpha > alphaOrganization.lastSynchronized() && cli.has("p") || personLastEditedBeta > betaOrganization.lastSynchronized() && cli.has("p") || articleLastEditedAlpha > alphaOrganization.lastSynchronized() && cli.has("a") || articleLastEditedBeta > betaOrganization.lastSynchronized() && cli.has("a")) {
            OrgSync.synchronizeFiles();
        }
        if (cli.has("p")) {
            if (personLastEditedAlpha > alphaOrganization.lastSynchronized() || personLastEditedBeta > betaOrganization.lastSynchronized()) {
                if (cli.has("pf")) {
                    person.setFilter(cli.parseFilter("pf"));
                }
                switch (person.synchronize()) {
                    case Success: {
                        System.out.println("success: people synchronized");
                        synced |= SynStep.Person.bit();
                        break;
                    }
                    case NoChange: {
                        System.out.println("no change: there are no people to synchronize.");
                        break;
                    }
                    case Error: {
                        System.out.println("error: failed to synchronize people!");
                    }
                }
            } else {
                System.out.println("success: all people are up-to-date!");
            }
        }
        if (cli.has("a")) {
            if (articleLastEditedAlpha > alphaOrganization.lastSynchronized() || articleLastEditedBeta > betaOrganization.lastSynchronized()) {
                if (cli.has("af")) {
                    article.setFilter(cli.parseFilter("af"));
                }
                switch (article.synchronize()) {
                    case Success: {
                        System.out.println("success: articles synchronized");
                        synced |= SynStep.Article.bit();
                        break;
                    }
                    case NoChange: {
                        System.out.println("no change: there are no articles to synchronize.");
                        break;
                    }
                    case Error: {
                        System.out.println("error: failed to synchronize articles!");
                    }
                }
            } else {
                System.out.println("success: all articles are up-to-date!");
            }
        }
    }

    private static void synchronizeFiles() {
        File.FileSyncMode mode = File.FileSyncMode.OnlyAttached;
        if (cli.has("fsm")) {
            String fsm = cli.get("fsm");
            if (fsm.equalsIgnoreCase("all")) {
                mode = File.FileSyncMode.All;
            } else if (fsm.equalsIgnoreCase("none")) {
                mode = File.FileSyncMode.None;
            }
        }
        File file = File.first(alphaOrganization, betaOrganization);
        if (!mode.equals((Object)File.FileSyncMode.None)) {
            file.setFileSyncMode(mode);
            switch (file.synchronize()) {
                case Success: {
                    System.out.println("success: files synchronized");
                    synced |= SynStep.File.bit();
                    break;
                }
                case NoChange: {
                    System.out.println("no change: there are no files to synchronize.");
                    break;
                }
                case Error: {
                    System.out.println("error: failed to synchronize files!");
                }
            }
        }
    }

    static enum SynStep {
        Nothing(0),
        Person(1),
        Article(2),
        File(4);

        final int bit;

        private SynStep(int b) {
            this.bit = b;
        }

        int bit() {
            return this.bit;
        }
    }
}

