/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Settings;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;

public class Organization {
    private final Settings settings = new Settings();
    private final String url;
    private final String authorization;
    private final String name;
    private long lastSynchronizedDelta = Duration.ofSeconds(10L).toMillis();
    private long lastSynchronized = 0L;

    public Organization(String organizationName, String key) {
        this.name = organizationName;
        this.url = organizationName.contains("https://") || organizationName.contains("http://") ? organizationName : "https://" + organizationName + ".cashctrl.com";
        this.authorization = "Basic " + Base64.getEncoder().encodeToString((key + ":").getBytes());
        try {
            this.lastSynchronized = Long.parseLong(this.settings.value("LAST_SYNCHRONIZED", this));
        }
        catch (Exception exception) {
            System.out.println("error: failed to get LAST_SYNCHRONIZED setting from " + this.name);
        }
    }

    public void updateLastSynchronized() {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("LAST_SYNCHRONIZED", Long.toString(new Date().getTime()));
            if (!this.settings.update(data, this)) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            System.out.println("error: failed to set LAST_SYNCHRONIZED setting inside organization " + this.name);
        }
    }

    public String url() {
        return this.url;
    }

    public String authorization() {
        return this.authorization;
    }

    public String name() {
        return this.name;
    }

    public long lastSynchronized() {
        return this.lastSynchronized + this.lastSynchronizedDelta;
    }

    public void lastSynchronizedDelta(long lastSynchronizedDelta) {
        this.lastSynchronizedDelta = lastSynchronizedDelta;
    }
}

