/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Attachment;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.PersonCategory;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.cashctrl.orgsync.Title;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;

public class Person
extends Attachment {
    private final PersonCategory personCategory;
    private final Title title;

    public Person(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/person/list.json", "/api/v1/person/read.json", "/api/v1/person/create.json", "/api/v1/person/update.json", "/api/v1/person/update_attachments.json", "nr", "");
        this.personCategory = new PersonCategory(alphaOrganization, betaOrganization);
        this.title = new Title(alphaOrganization, betaOrganization);
    }

    @Override
    public SyncObject.State synchronize() {
        SyncData syncData;
        this.http.setRequestDuration(Duration.ofSeconds(20L));
        SyncObject.State state = SyncObject.State.Success;
        System.out.println("--------- synchronize: person categories ---------");
        if (this.filter != null && this.filter.containsKey("category")) {
            this.personCategory.setFilter(this.filter);
        }
        switch (this.personCategory.synchronize()) {
            case Success: {
                System.out.println("success: person categories synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no person categories to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize person categories!");
                state = SyncObject.State.Error;
            }
        }
        System.out.println("--------- synchronize: titles ---------");
        switch (this.title.synchronize()) {
            case Success: {
                System.out.println("success: titles synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no titles to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize titles!");
                state = SyncObject.State.Error;
            }
        }
        System.out.println("--------- synchronize: people ---------");
        HashMap<String, String> alphaFilter = new HashMap<String, String>();
        HashMap<String, String> betaFilter = new HashMap<String, String>();
        if (this.filter != null) {
            if (this.filter.containsKey("category")) {
                if (!this.personCategory.prepareFilter(this.filter, alphaFilter, betaFilter)) {
                    System.out.println("error: failed to prepare category filter");
                    return SyncObject.State.Error;
                }
            } else {
                alphaFilter.putAll(this.filter);
                betaFilter.putAll(this.filter);
            }
        }
        HashMap<JsonObject, JsonObject> alphaHierarchicalMap = new HashMap<JsonObject, JsonObject>();
        HashMap<JsonObject, JsonObject> betaHierarchicalMap = new HashMap<JsonObject, JsonObject>();
        JsonArray alphaPeople = this.list(alphaFilter, this.alphaOrganization);
        JsonArray betaPeople = this.list(betaFilter, this.betaOrganization);
        if (alphaPeople == null || betaPeople == null) {
            return SyncObject.State.Error;
        }
        if (alphaPeople.isEmpty() && betaPeople.isEmpty()) {
            return SyncObject.State.NoChange;
        }
        for (int alphaIdx = 0; alphaIdx < alphaPeople.size(); ++alphaIdx) {
            JsonObject personAlphaDetails;
            JsonObject personAlpha = alphaPeople.get(alphaIdx).getAsJsonObject();
            if (!this.isValid(personAlpha)) continue;
            boolean existsInBeta = false;
            for (int betaIdx = 0; betaIdx < betaPeople.size(); ++betaIdx) {
                SyncData syncData2;
                long betaTime;
                JsonObject personBeta = betaPeople.get(betaIdx).getAsJsonObject();
                if (!this.isValid(personBeta) || !this.equals(personAlpha, personBeta)) continue;
                existsInBeta = true;
                long alphaTime = this.lastUpdated(personAlpha);
                if (alphaTime == (betaTime = this.lastUpdated(personBeta)) || alphaTime <= this.alphaOrganization.lastSynchronized() && betaTime <= this.betaOrganization.lastSynchronized()) continue;
                JsonObject personAlphaDetails2 = this.read(personAlpha.get("id").getAsInt(), this.alphaOrganization);
                JsonObject personBetaDetails = this.read(personBeta.get("id").getAsInt(), this.betaOrganization);
                if (alphaTime > betaTime && alphaTime > this.alphaOrganization.lastSynchronized()) {
                    syncData2 = new SyncData(personAlpha, personBeta, personAlphaDetails2, personBetaDetails);
                    if (this.updatePerson(syncData2, betaHierarchicalMap, this.alphaOrganization, this.betaOrganization)) continue;
                    state = SyncObject.State.Error;
                    continue;
                }
                if (betaTime <= alphaTime || betaTime <= this.betaOrganization.lastSynchronized() || this.updatePerson(syncData2 = new SyncData(personBeta, personAlpha, personBetaDetails, personAlphaDetails2), alphaHierarchicalMap, this.betaOrganization, this.alphaOrganization)) continue;
                state = SyncObject.State.Error;
            }
            if (existsInBeta || this.createPerson(syncData = new SyncData(personAlpha, new JsonObject(), personAlphaDetails = this.read(personAlpha.get("id").getAsInt(), this.alphaOrganization), new JsonObject()), betaHierarchicalMap, this.alphaOrganization, this.betaOrganization)) continue;
            state = SyncObject.State.Error;
        }
        for (int betaIdx = 0; betaIdx < betaPeople.size(); ++betaIdx) {
            JsonObject personBetaDetails;
            JsonObject personBeta = betaPeople.get(betaIdx).getAsJsonObject();
            if (!this.isValid(personBeta)) continue;
            boolean existsInAlpha = false;
            for (int alphaIdx = 0; alphaIdx < alphaPeople.size(); ++alphaIdx) {
                JsonObject personAlpha = alphaPeople.get(alphaIdx).getAsJsonObject();
                if (!this.isValid(personAlpha) || !this.equals(personAlpha, personBeta)) continue;
                existsInAlpha = true;
            }
            if (existsInAlpha || this.createPerson(syncData = new SyncData(personBeta, new JsonObject(), personBetaDetails = this.read(personBeta.get("id").getAsInt(), this.betaOrganization), new JsonObject()), alphaHierarchicalMap, this.betaOrganization, this.alphaOrganization)) continue;
            state = SyncObject.State.Error;
        }
        this.updateSuperiorIds(alphaHierarchicalMap, this.alphaOrganization);
        this.updateSuperiorIds(betaHierarchicalMap, this.betaOrganization);
        return state;
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject person = syncData.source();
        JsonObject personDetails = syncData.sourceDetails();
        List<SyncObject.Parameter> fields = List.of(new SyncObject.Parameter("company", person, SyncObject.DataType.STRING), new SyncObject.Parameter("firstName", person, SyncObject.DataType.STRING), new SyncObject.Parameter("lastName", person, SyncObject.DataType.STRING), new SyncObject.Parameter("altName", person, SyncObject.DataType.STRING), new SyncObject.Parameter("bankData", person, SyncObject.DataType.STRING), new SyncObject.Parameter("bic", person, SyncObject.DataType.STRING), new SyncObject.Parameter("color", person, SyncObject.DataType.STRING), new SyncObject.Parameter("custom", person, SyncObject.DataType.STRING), new SyncObject.Parameter("dateBirth", person, SyncObject.DataType.STRING), new SyncObject.Parameter("department", person, SyncObject.DataType.STRING), new SyncObject.Parameter("iban", person, SyncObject.DataType.STRING), new SyncObject.Parameter("industry", person, SyncObject.DataType.STRING), new SyncObject.Parameter("language", person, SyncObject.DataType.STRING), new SyncObject.Parameter("notes", person, SyncObject.DataType.STRING), new SyncObject.Parameter("nr", person, SyncObject.DataType.STRING), new SyncObject.Parameter("position", person, SyncObject.DataType.STRING), new SyncObject.Parameter("ssn", person, SyncObject.DataType.STRING), new SyncObject.Parameter("vatUid", person, SyncObject.DataType.STRING), new SyncObject.Parameter("certificateValues", personDetails, SyncObject.DataType.STRING), new SyncObject.Parameter("categoryId", person, SyncObject.DataType.INT), new SyncObject.Parameter("superiorId", person, SyncObject.DataType.INT), new SyncObject.Parameter("titleId", person, SyncObject.DataType.INT), new SyncObject.Parameter("discountPercentage", person, SyncObject.DataType.FLOAT), new SyncObject.Parameter("isAutoFillResponsiblePerson", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isCustomer", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isEmployee", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isFamily", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isHideCompany", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isHideName", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isInactive", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isInsurance", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isVendor", person, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("bankAccounts", personDetails, SyncObject.DataType.JSON_ARRAY), new SyncObject.Parameter("children", personDetails, SyncObject.DataType.JSON_ARRAY), new SyncObject.Parameter("insuranceContracts", personDetails, SyncObject.DataType.JSON_ARRAY), new SyncObject.Parameter("servicePeriods", personDetails, SyncObject.DataType.JSON_ARRAY), new SyncObject.Parameter("addresses", personDetails, SyncObject.DataType.JSON_ARRAY), new SyncObject.Parameter("contacts", personDetails, SyncObject.DataType.JSON_ARRAY));
        return this.parametrizeParams(fields);
    }

    @Override
    public boolean isValid(JsonObject person) {
        return this.has(person, "id") && this.has(person, "nr") && this.has(person, "lastUpdated") && (this.has(person, "firstName") || this.has(person, "lastName") || this.has(person, "company"));
    }

    @Override
    protected JsonArray list(HashMap<String, String> filter, Organization organization) {
        if (filter != null && !filter.containsKey("limit")) {
            filter.put("limit", Integer.toString(99999));
        }
        return super.list(filter, organization);
    }

    private boolean createPerson(SyncData syncData, HashMap<JsonObject, JsonObject> hierarchicalMap, Organization sourceOrganization, Organization targetOrganization) {
        this.updateDependencies(syncData, hierarchicalMap, sourceOrganization, targetOrganization);
        if (!this.create(syncData, targetOrganization, sourceOrganization)) {
            System.out.println("error: failed to create person in organization: " + targetOrganization.name());
            return false;
        }
        this.updateAttachments(syncData, targetOrganization);
        return true;
    }

    private boolean updatePerson(SyncData syncData, HashMap<JsonObject, JsonObject> hierarchicalMap, Organization sourceOrganization, Organization targetOrganization) {
        this.updateDependencies(syncData, hierarchicalMap, sourceOrganization, targetOrganization);
        if (!this.update(syncData, targetOrganization, sourceOrganization)) {
            System.out.println("error: failed to update person in organization: " + targetOrganization.name());
            return false;
        }
        this.updateAttachments(syncData, targetOrganization);
        return true;
    }

    private void updateDependencies(SyncData syncData, HashMap<JsonObject, JsonObject> hierarchicalMap, Organization sourceOrganization, Organization targetOrganization) {
        if (this.has(syncData.source(), "categoryId")) {
            this.personCategory.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
        if (this.has(syncData.source(), "titleId")) {
            this.title.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
        if (this.has(syncData.source(), "superiorId")) {
            this.addHierarchicalEntry(syncData, hierarchicalMap, sourceOrganization);
        }
    }

    private void addHierarchicalEntry(SyncData syncData, HashMap<JsonObject, JsonObject> collection, Organization sourceOrganization) {
        JsonObject subordinate = syncData.source();
        int superiorId = subordinate.get("superiorId").getAsInt();
        subordinate.remove("superiorId");
        String subordinateNr = subordinate.get("nr").getAsString();
        JsonObject superior = this.read(superiorId, sourceOrganization);
        if (this.isValid(superior)) {
            collection.put(subordinate, superior);
            return;
        }
        System.out.println("error: could not find superior of person with personal number: " + subordinateNr + " superiorId: " + superiorId);
    }

    private void updateSuperiorIds(HashMap<JsonObject, JsonObject> hierarchicalMap, Organization organization) {
        hierarchicalMap.forEach((key, value) -> {
            JsonArray peopleArray = this.list(organization);
            JsonObject subordinate = this.equivalent((JsonObject)key, peopleArray);
            JsonObject superior = this.equivalent((JsonObject)value, peopleArray);
            if (subordinate != null && superior != null && this.isValid(subordinate) && this.isValid(superior)) {
                subordinate.addProperty("superiorId", superior.get("id").getAsInt());
                SyncData syncData = new SyncData(subordinate, subordinate, new JsonObject(), new JsonObject());
                this.update(syncData, organization, null);
            }
        });
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject person) {
        if (this.has(person, "id")) {
            info.append(" id: ").append(person.get("id"));
        }
        if (this.has(person, "nr")) {
            info.append(" nr: ").append(person.get("nr"));
        }
        if (this.has(person, "firstName")) {
            info.append(" firstName: ").append(person.get("firstName"));
        }
        if (this.has(person, "categoryId")) {
            info.append(" categoryId: ").append(person.get("categoryId"));
        }
        if (this.has(person, "titleId")) {
            info.append(" titleId: ").append(person.get("titleId"));
        }
        if (this.has(person, "superiorId")) {
            info.append(" superiorId: ").append(person.get("superiorId"));
        }
    }
}

