/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.Category;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;

public class FileCategory
extends Category {
    public FileCategory(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/file/category/list.json", "/api/v1/file/category/read.json", "/api/v1/file/category/create.json", "/api/v1/file/category/update.json", "/api/v1/file/category/tree.json");
    }

    @Override
    public SyncObject.State synchronize() {
        JsonArray alphaTree = this.tree(-1, this.alphaOrganization);
        JsonArray betaTree = this.tree(-1, this.betaOrganization);
        if (alphaTree == null || betaTree == null) {
            return SyncObject.State.Error;
        }
        if (alphaTree.isEmpty() && betaTree.isEmpty()) {
            return SyncObject.State.NoChange;
        }
        int rootId = 0;
        JsonObject alphaRoot = alphaTree.get(rootId).getAsJsonObject();
        JsonObject betaRoot = betaTree.get(rootId).getAsJsonObject();
        if (alphaRoot == null || betaRoot == null) {
            return SyncObject.State.Error;
        }
        if (!this.has(alphaRoot, "data") && !this.has(betaRoot, "data")) {
            return SyncObject.State.NoChange;
        }
        return super.synchronize(alphaRoot.get("data").getAsJsonArray(), betaRoot.get("data").getAsJsonArray(), rootId, rootId);
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject fileCategory = syncData.source();
        List<SyncObject.Parameter> fields = List.of(new SyncObject.Parameter("name", fileCategory, SyncObject.DataType.STRING), new SyncObject.Parameter("parentId", fileCategory, SyncObject.DataType.INT));
        return this.parametrizeParams(fields);
    }
}

