/*
 * Decompiled with CFR 0.152.
 */
package com.cashctrl.orgsync;

import com.cashctrl.orgsync.ArticleCategory;
import com.cashctrl.orgsync.Attachment;
import com.cashctrl.orgsync.Currency;
import com.cashctrl.orgsync.Organization;
import com.cashctrl.orgsync.SyncData;
import com.cashctrl.orgsync.SyncObject;
import com.cashctrl.orgsync.Unit;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;

public class Article
extends Attachment {
    private final ArticleCategory articleCategory;
    private final Unit unit;
    private final Currency currency;

    public Article(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/inventory/article/list.json", "/api/v1/inventory/article/read.json", "/api/v1/inventory/article/create.json", "/api/v1/inventory/article/update.json", "/api/v1/inventory/article/update_attachments.json", "nr", "");
        this.articleCategory = new ArticleCategory(alphaOrganization, betaOrganization);
        this.unit = new Unit(alphaOrganization, betaOrganization);
        this.currency = new Currency(alphaOrganization, betaOrganization);
    }

    @Override
    public SyncObject.State synchronize() {
        SyncData syncData;
        this.http.setRequestDuration(Duration.ofSeconds(20L));
        SyncObject.State state = SyncObject.State.Success;
        System.out.println("--------- synchronize: article categories ---------");
        if (this.filter != null && this.filter.containsKey("category")) {
            this.articleCategory.setFilter(this.filter);
        }
        switch (this.articleCategory.synchronize()) {
            case Success: {
                System.out.println("success: article categories synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no article categories to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize article categories!");
                state = SyncObject.State.Error;
            }
        }
        System.out.println("--------- synchronize: units ---------");
        switch (this.unit.synchronize()) {
            case Success: {
                System.out.println("success: units synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no units to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize units!");
                state = SyncObject.State.Error;
            }
        }
        System.out.println("--------- synchronize: currencies ---------");
        switch (this.currency.synchronize()) {
            case Success: {
                System.out.println("success: currencies synchronized");
                break;
            }
            case NoChange: {
                System.out.println("no change: there are no currencies to synchronize.");
                break;
            }
            case Error: {
                System.out.println("error: failed to synchronize currencies!");
                state = SyncObject.State.Error;
            }
        }
        System.out.println("--------- synchronize: articles ---------");
        HashMap<String, String> alphaFilter = new HashMap<String, String>();
        HashMap<String, String> betaFilter = new HashMap<String, String>();
        if (this.filter != null) {
            if (this.filter.containsKey("category")) {
                if (!this.articleCategory.prepareFilter(this.filter, alphaFilter, betaFilter)) {
                    System.out.println("error: failed to prepare category filter");
                    return SyncObject.State.Error;
                }
            } else {
                alphaFilter.putAll(this.filter);
                betaFilter.putAll(this.filter);
            }
        }
        JsonArray alphaArticles = this.list(alphaFilter, this.alphaOrganization);
        JsonArray betaArticles = this.list(betaFilter, this.betaOrganization);
        if (alphaArticles == null || betaArticles == null) {
            return SyncObject.State.Error;
        }
        if (alphaArticles.isEmpty() && betaArticles.isEmpty()) {
            return SyncObject.State.NoChange;
        }
        for (int alphaIdx = 0; alphaIdx < alphaArticles.size(); ++alphaIdx) {
            JsonObject articleAlphaDetails;
            JsonObject articleAlpha = alphaArticles.get(alphaIdx).getAsJsonObject();
            if (!this.isValid(articleAlpha)) continue;
            boolean existsInBeta = false;
            for (int betaIdx = 0; betaIdx < betaArticles.size(); ++betaIdx) {
                SyncData syncData2;
                long betaTime;
                JsonObject articleBeta = betaArticles.get(betaIdx).getAsJsonObject();
                if (!this.isValid(articleBeta) || !this.equals(articleAlpha, articleBeta)) continue;
                existsInBeta = true;
                long alphaTime = this.lastUpdated(articleAlpha);
                if (alphaTime == (betaTime = this.lastUpdated(articleBeta)) || alphaTime <= this.alphaOrganization.lastSynchronized() && betaTime <= this.betaOrganization.lastSynchronized()) continue;
                JsonObject articleAlphaDetails2 = this.read(articleAlpha.get("id").getAsInt(), this.alphaOrganization);
                JsonObject articleBetaDetails = this.read(articleBeta.get("id").getAsInt(), this.betaOrganization);
                if (alphaTime > betaTime && alphaTime > this.alphaOrganization.lastSynchronized()) {
                    syncData2 = new SyncData(articleAlpha, articleBeta, articleAlphaDetails2, articleBetaDetails);
                    if (this.updateArticle(syncData2, this.alphaOrganization, this.betaOrganization)) continue;
                    state = SyncObject.State.Error;
                    continue;
                }
                if (betaTime <= alphaTime || betaTime <= this.betaOrganization.lastSynchronized() || this.updateArticle(syncData2 = new SyncData(articleBeta, articleAlpha, articleBetaDetails, articleAlphaDetails2), this.betaOrganization, this.alphaOrganization)) continue;
                state = SyncObject.State.Error;
            }
            if (existsInBeta || this.createArticle(syncData = new SyncData(articleAlpha, new JsonObject(), articleAlphaDetails = this.read(articleAlpha.get("id").getAsInt(), this.alphaOrganization), new JsonObject()), this.alphaOrganization, this.betaOrganization)) continue;
            state = SyncObject.State.Error;
        }
        for (int betaIdx = 0; betaIdx < betaArticles.size(); ++betaIdx) {
            JsonObject articleBetaDetails;
            JsonObject articleBeta = betaArticles.get(betaIdx).getAsJsonObject();
            if (!this.isValid(articleBeta)) continue;
            boolean existsInAlpha = false;
            for (int alphaIdx = 0; alphaIdx < alphaArticles.size(); ++alphaIdx) {
                JsonObject articleAlpha = alphaArticles.get(alphaIdx).getAsJsonObject();
                if (!this.isValid(articleAlpha) || !this.equals(articleAlpha, articleBeta)) continue;
                existsInAlpha = true;
            }
            if (existsInAlpha || this.createArticle(syncData = new SyncData(articleBeta, new JsonObject(), articleBetaDetails = this.read(articleBeta.get("id").getAsInt(), this.betaOrganization), new JsonObject()), this.betaOrganization, this.alphaOrganization)) continue;
            state = SyncObject.State.Error;
        }
        return state;
    }

    @Override
    protected JsonArray list(HashMap<String, String> filter, Organization organization) {
        if (filter != null && !filter.containsKey("limit")) {
            filter.put("limit", Integer.toString(99999));
        }
        return super.list(filter, organization);
    }

    private boolean createArticle(SyncData syncData, Organization sourceOrganization, Organization targetOrganization) {
        this.updateDependencies(syncData, sourceOrganization, targetOrganization);
        if (!this.create(syncData, targetOrganization, sourceOrganization)) {
            System.out.println("error: failed to create article in organization: " + targetOrganization.name());
            return false;
        }
        this.updateAttachments(syncData, targetOrganization);
        return true;
    }

    private boolean updateArticle(SyncData syncData, Organization sourceOrganization, Organization targetOrganization) {
        this.updateDependencies(syncData, sourceOrganization, targetOrganization);
        if (!this.update(syncData, targetOrganization, sourceOrganization)) {
            System.out.println("error: failed to update article in organization: " + targetOrganization.name());
            return false;
        }
        this.updateAttachments(syncData, targetOrganization);
        return true;
    }

    private void updateDependencies(SyncData syncData, Organization sourceOrganization, Organization targetOrganization) {
        if (this.has(syncData.source(), "categoryId")) {
            this.articleCategory.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
        if (this.has(syncData.source(), "unitId")) {
            this.unit.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
        if (this.has(syncData.source(), "currencyId")) {
            this.currency.fixDependency(syncData, sourceOrganization, targetOrganization);
        }
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject article = syncData.source();
        List<SyncObject.Parameter> fields = List.of(new SyncObject.Parameter("name", article, SyncObject.DataType.STRING), new SyncObject.Parameter("binLocation", article, SyncObject.DataType.STRING), new SyncObject.Parameter("custom", article, SyncObject.DataType.STRING), new SyncObject.Parameter("description", article, SyncObject.DataType.STRING), new SyncObject.Parameter("notes", article, SyncObject.DataType.STRING), new SyncObject.Parameter("nr", article, SyncObject.DataType.STRING), new SyncObject.Parameter("categoryId", article, SyncObject.DataType.INT), new SyncObject.Parameter("currencyId", article, SyncObject.DataType.INT), new SyncObject.Parameter("unitId", article, SyncObject.DataType.INT), new SyncObject.Parameter("lastPurchasePrice", article, SyncObject.DataType.FLOAT), new SyncObject.Parameter("salesPrice", article, SyncObject.DataType.FLOAT), new SyncObject.Parameter("maxStock", article, SyncObject.DataType.DOUBLE), new SyncObject.Parameter("minStock", article, SyncObject.DataType.DOUBLE), new SyncObject.Parameter("stock", article, SyncObject.DataType.DOUBLE), new SyncObject.Parameter("isInactive", article, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isPurchasePriceGross", article, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isSalesPriceGross", article, SyncObject.DataType.BOOLEAN), new SyncObject.Parameter("isStockArticle", article, SyncObject.DataType.BOOLEAN));
        return this.parametrizeParams(fields);
    }

    @Override
    public boolean isValid(JsonObject article) {
        return this.has(article, "id") && this.has(article, "name") && this.has(article, "lastUpdated");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject article) {
        if (this.has(article, "id")) {
            info.append(" id: ").append(article.get("id"));
        }
        if (this.has(article, "name")) {
            info.append(" name; ").append(article.get("name").getAsString());
        }
        if (this.has(article, "binLocation")) {
            info.append(" binLocation: ").append(article.get("binLocation").getAsString());
        }
        if (this.has(article, "categoryId")) {
            info.append(" categoryId: ").append(article.get("categoryId").getAsInt());
        }
        if (this.has(article, "currencyId")) {
            info.append(" currencyId: ").append(article.get("currencyId").getAsInt());
        }
        if (this.has(article, "locationId")) {
            info.append(" locationId: ").append(article.get("locationId").getAsInt());
        }
        if (this.has(article, "nr")) {
            info.append(" nr: ").append(article.get("nr").getAsString());
        }
        if (this.has(article, "unitId")) {
            info.append(" unitId ").append(article.get("unitId").getAsInt());
        }
    }
}

