package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

import java.net.http.HttpResponse;
import java.util.HashMap;

/**
 * Settings API, list, get and update settings
 * @author Silian Barlogis
 * @see SyncObject
 */
public class Settings extends SyncObject {

    /**
     * SyncObject constructor
     */
    protected Settings() {
        super(null, null, "/api/v1/setting/read.json", "/api/v1/setting/get", "",
                "/api/v1/setting/update.json", "", "");
    }

    /**
     * List data in the given organization.
     * @param organization the organization to list from
     * @return response data as json array
     */
    @SuppressWarnings("unused")
    protected JsonObject listAll(Organization organization) {
        HttpResponse<String> response = http.get(organization, listEndpoint, filter, HttpResponse.BodyHandlers.ofString());
        if (response != null && response.statusCode() == 200) {
            return gson.fromJson(response.body(), JsonObject.class);
        }
        return null;
    }

    /**
     * Returns the value of a setting.
     * @param key the setting name
     * @param organization the organization to get the settings from
     * @return the setting value
     */
    protected String value(String key, Organization organization) {
        HashMap<String, String> data = new HashMap<>();
        data.put("name", key);
        HttpResponse<String> response = http.get(organization, readEndpoint, data, HttpResponse.BodyHandlers.ofString());
        if (response != null && response.statusCode() == 200) {
            return response.body();
        }
        return null;
    }

    /**
     * Updates or create a setting if it does not exist
     * @param settings the setting to update or create
     * @param organization the organization
     * @return true if successful
     */
    protected boolean update(HashMap<String, String> settings, Organization organization) {
        return checkResponse(http.post(organization, updateEndpoint, settings, HttpResponse.BodyHandlers.ofString()), null, "Update settings");
    }

    @Override
    protected HashMap<String, String> parametrize(final SyncData syncData) {
        return null;
    }

    @Override
    protected boolean isValid(final JsonObject object) {
        return false;
    }

    @Override
    protected void vitalInfo(final StringBuilder info, final JsonObject subject) {

    }
}