package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.List;

/**
 * Currency API synchronize, list, read, create and update Currencies.
 * @author Silian Barlogis
 * @see SyncObject
 */
public class Currency extends SyncObject {

    /**
     * Currency constructor, initializes all needed endpoints for currency synchronization.
     * @param alphaOrganization alpha organization
     * @param betaOrganization beta organization
     */
    public Currency(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/currency/list.json", "/api/v1/currency/read.json",
                "/api/v1/currency/create.json", "/api/v1/currency/update.json", "code", "currencyId");
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject currency = syncData.source();

        var fields = List.of(
                // TEXT
                new Parameter("code", currency, DataType.STRING),
                new Parameter("description", currency, DataType.STRING),

                // BOOLEAN
                new Parameter("isDefault", currency, DataType.BOOLEAN),

                // NUMBER
                new Parameter("rate", currency, DataType.DOUBLE)
        );

        return parametrizeParams(fields);
    }

    @Override
    public boolean isValid(JsonObject currency) {
        return has(currency, "id") && has(currency, "code") &&
                has(currency, "lastUpdated");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject currency) {
        if (has(currency, "id"))
            info.append(" id: ").append(currency.get("id"));
        if (has(currency, "name"))
            info.append(" name: ").append(currency.get("name"));
        if (has(currency, "description"))
            info.append(" description: ").append(currency.get("description"));
    }
}