package com.cashctrl.orgsync;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.List;

/**
 * Article category API synchronize, list, read, create and update article categories.
 * @author Silian Barlogis
 * @see SyncObject
 * @see com.cashctrl.orgsync.Category
 */
public class ArticleCategory extends Category {

    /**
     * Article category constructor, initializes all needed endpoints for article category synchronization.
     * @param alphaOrganization alpha organization
     * @param betaOrganization beta organization
     */
    public ArticleCategory(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/inventory/article/category/list.json", "/api/v1/inventory/article/category/read.json",
                "/api/v1/inventory/article/category/create.json", "/api/v1/inventory/article/category/update.json",
                "/api/v1/inventory/article/category/tree.json");
    }

    @Override
    protected JsonObject equivalent(String searchValue, JsonArray pool) {
        for (int idx = 0; idx < pool.size(); idx++) {
            JsonObject obj = pool.get(idx).getAsJsonObject();
            if (has(obj, equalProperty) && obj.get(equalProperty).getAsString().contains(searchValue)) {
                return obj;
            }
        }
        return null;
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject articleCategory = syncData.source();

        var fields = List.of(
                // TEXT
                new Parameter("name", articleCategory, DataType.STRING),

                // JSON
                new Parameter("allocations", articleCategory, DataType.JSON_ARRAY),

                // NUMBER
                new Parameter("parentId", articleCategory, DataType.INT),
                new Parameter("purchaseAccountId", articleCategory, DataType.INT),
                new Parameter("salesAccountId", articleCategory, DataType.INT),
                new Parameter("sequenceNrId", articleCategory, DataType.INT)
        );

        return parametrizeParams(fields);
    }
}