package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

/**
 * Record / data class for synchronisation data.
 * Source holds the source data which will be synchronized to the target.
 * SourceDetails holds additional data for example addresses and contacts from people.
 * @param source source data
 * @param target target data
 * @param sourceDetails source detail data
 * @param targetDetails target detail data
 * @author Silian Barlogis
 */
public record SyncData(JsonObject source, JsonObject target, JsonObject sourceDetails, JsonObject targetDetails) {

    /**
     * Additional constructor mainly for create action where only source is required.
     * @param source source data
     */
    public SyncData(JsonObject source) {
        this(source, new JsonObject(), new JsonObject(), new JsonObject());
    }

    /**
     * Additional constructor used for update action where not additional information is required.
     * @param source source data
     * @param target target data
     */
    public SyncData(JsonObject source, JsonObject target) {
        this(source, target, new JsonObject(), new JsonObject());
    }
}