package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.List;

/**
 * Unit API synchronize, list, read, create and update units.
 * @author Silian Barlogis
 * @see SyncObject
 */
public class Unit extends SyncObject {

    /**
     * Unit constructor, initializes all needed endpoints for unit synchronization.
     * @param alphaOrganization alpha organization
     * @param betaOrganization beta organization
     */
    public Unit(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/inventory/unit/list.json", "/api/v1/inventory/unit/read.json",
                "/api/v1/inventory/unit/create.json", "/api/v1/inventory/unit/update.json", "name", "unitId");
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject unit = syncData.source();

        var fields = List.of(
                // TEXT
                new Parameter("name", unit, DataType.STRING) // optional
        );

        return parametrizeParams(fields);
    }

    @Override
    public boolean isValid(JsonObject unit) {
        return has(unit, "id") && has(unit, "name") &&
                has(unit, "lastUpdated");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject unit) {
        if (has(unit, "id"))
            info.append(" id: ").append(unit.get("id"));
        if (has(unit, "name"))
            info.append(" name: ").append(unit.get("name"));
    }
}