package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.List;

/**
 * Title API synchronize, list, read, create and update titles.
 * @author Silian Barlogis
 * @see SyncObject
 */
public class Title extends SyncObject {

    /**
     * Title constructor, initializes all needed endpoints for title synchronization.
     * @param alphaOrganization alpha organization
     * @param betaOrganization beta organization
     */
    public Title(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/person/title/list.json", "/api/v1/person/title/read.json",
                "/api/v1/person/title/create.json", "/api/v1/person/title/update.json", "name", "titleId");
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject title = syncData.source();

        var fields = List.of(
                // TEXT
                new Parameter("name", title, DataType.STRING),
                new Parameter("gender", title, DataType.STRING),
                new Parameter("sentence", title, DataType.STRING)
        );

        return parametrizeParams(fields);
    }

    @Override
    protected String getInfo(SyncData syncData, String action) {
        StringBuilder info = new StringBuilder();
        info.append("title ACTION: ").append(action).append("\n");

        if (syncData.source() != null) {
            info.append("SOURCE: ");
            vitalInfo(info, syncData.source());
            info.append("\n");
        } else {
            info.append(" SOURCE is null\n");
        }

        if (syncData.target() != null) {
            info.append("TARGET: ");
            vitalInfo(info, syncData.target());
        } else {
            info.append(" TARGET is null");
        }

        return info.toString();
    }

    @Override
    public boolean isValid(JsonObject title) {
        return has(title, "id") && has(title, "name") &&
                has(title, "lastUpdated");
    }

    @Override
    protected void vitalInfo(StringBuilder info, JsonObject title) {
        if (has(title, "id"))
            info.append(" id: ").append(title.get("id"));
        if (has(title, "name"))
            info.append(" name: ").append(title.get("name"));
    }
}