package com.cashctrl.orgsync;

import com.google.gson.JsonObject;

import java.util.HashMap;
import java.util.List;

/**
 * Person category API synchronize, list, read, create and update person categories.
 * @author Silian Barlogis
 * @see SyncObject
 * @see com.cashctrl.orgsync.Category
 */
public class PersonCategory extends Category {

    /**
     * Person category constructor, initializes all needed endpoints for person category synchronization.
     * @param alphaOrganization alpha organization
     * @param betaOrganization beta organization
     */
    public PersonCategory(Organization alphaOrganization, Organization betaOrganization) {
        super(alphaOrganization, betaOrganization, "/api/v1/person/category/list.json", "/api/v1/person/category/read.json",
                "/api/v1/person/category/create.json", "/api/v1/person/category/update.json",
                "/api/v1/person/category/tree.json");
    }

    @Override
    protected HashMap<String, String> parametrize(SyncData syncData) {
        JsonObject personCategory = syncData.source();

        var fields = List.of(
                // TEXT
                new Parameter("name", personCategory, DataType.STRING),

                // NUMBER
                new Parameter("discountPercentage", personCategory, DataType.FLOAT),
                new Parameter("parentId", personCategory, DataType.INT),
                new Parameter("sequenceNrId", personCategory, DataType.INT)
        );

        return parametrizeParams(fields);
    }
}